/***************************************************************************
* Copyright(c) 2020-2020 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
#define DP_INF4CV_REGIONTYPE_EU 1
#define DP_INF4CV_REGIONTYPE_TURKISH 2
#define DP_INF4CV_VEHICLETYPE_COACH 1
#define DP_INF4CV_VEHICLETYPE_TRUCK 0
#define DP_INF4CV_VEHICLETYPE_SMART 2
#define DP_INF4CV_VARIANTSELECTION_NAVI 1
#define DP_INF4CV_VARIANTSELECTION_NONNAVI 2
#define DP_INF4CV_VARIANTSELECTION_NO3D 3
#define DP_INF4CV_VARIANTSELECTION_CABIN_ONLY 4


#define BEGIN_CONFIGURE_HOMESCREEN_LIST_INFO()                                                            \
::std::map< uint32, HomeListInfo > listInfo;

#define BEGIN_LIST(_listId_, _regionId_, _cond_)                                                          \
if (_cond_)                                                                                               \
{                                                                                                         \
   uint32 listId = _listId_;                                                                              \
   uint32 regionId = _regionId_;                                                                          \
   ::std::vector< HomeListItemInfo > listItemInfo;

#define ADD_VIEW_ID(_id_)                                                                                 \
   uint32 viewId = _id_;

#define BEGIN_LIST_ITEM_INFO(_cond_)                                                                      \
   if (_cond_)                                                                                            \
   {                                                                                                      \
      HomeListItemInfo obj;

#define ADD_INSTANCE_ID(_id_)                                                                             \
      obj.setInstanceId(_id_);

#define ADD_ITEM_INDEX(_id_)                                                                              \
      obj.setItemIndex(_id_);

#define ADD_DATA_CONTEXT(_context_)                                                                       \
      obj.setGadgetDataItemContext(_context_);

#define ADD_GADGET_VISIBILITY(_status_)                                                                   \
      obj.setGadgetVisibleStatus(_status_);

#define ADD_BITMAP_BG(_bg_)                                                                               \
      obj.setBitmapBg(_bg_);

#define ADD_BITMAP_ICON_BG_NORMAL(_iconBgNormal_)                                                         \
      obj.setBitmapIconNormalBg(_iconBgNormal_);

#define ADD_BITMAP_ICON_BG_PRESSED(_iconBgPressed_)                                                       \
      obj.setBitmapIconPressedBg(_iconBgPressed_);

#define ADD_ICON(_icon_)                                                                                  \
      obj.setBitmapIcon(_icon_);

#define ADD_DISABLED_BG(_bg_)                                                                             \
      obj.setDisabledBitmapBg(_bg_);

#define ADD_DISABLED_ICON(_icon_)                                                                         \
      obj.setDisabledBitmapIcon(_icon_);

#define ADD_DISABLED_TRANSPARENT_BG(_bg_)                                                                 \
      obj.setDisabledBitmapTransparentBg(_bg_);

#define ADD_BITMAP_TOUCH_AREA_BG_NORMAL(_touchAreaBgNormal_)                                              \
      obj.setBitmapTouchAreaNormalBg(_touchAreaBgNormal_);

#define ADD_BITMAP_TOUCH_AREA_BG_PRESSED(_touchAreaBgPressed_)                                            \
      obj.setBitmapTouchAreaPressedBg(_touchAreaBgPressed_);

#define ADD_TEXT(_textId_)                                                                                \
      obj.setTouchAreaText(_textId_);

#define ADD_COLOR(_red_, _green_, _blue_)                                                                 \
      obj.setTextColour(Candera::Color(_red_, _green_, _blue_));

#define ADD_GADGET_MARGIN(_left_, _top_, _right_, _bottom_)                                               \
      obj.setGadgetMargin(Candera::Margin(_left_, _top_, _right_, _bottom_));

#define ADD_GADGET_FUNCTION_NA_MARGIN(_left_, _top_, _right_, _bottom_)                                   \
      obj.setGadgetFunctionNAMargin(Candera::Margin(_left_, _top_, _right_, _bottom_));

#define ADD_GADGET_LOADING_ICON_MARGIN(_left_, _top_, _right_, _bottom_)                                  \
      obj.setGadgetLoadingIconMargin(Candera::Margin(_left_, _top_, _right_, _bottom_));

#define ADD_GADGET_SIZE(_xsize_, _ysize_)                                                                 \
      obj.setGadgetSize(Candera::Vector2(_xsize_, _ysize_));

#define ADD_GADGET_CONTENT_AVAILABLE(_status_)                                                            \
      obj.setGadgetContentAvailable(_status_);

#define END_LIST_ITEM_INFO()                                                                              \
      listItemInfo.push_back(obj);                                                                        \
   }

#define END_LIST()                                                                                        \
   listInfo.insert(::std::pair<uint32, HomeListInfo>(listId, HomeListInfo(regionId, viewId, listItemInfo)));     \
}                                                                                                         \

#define END_CONFIGURE_HOMESCREEN_LIST_INFO()                                                              \
return listInfo;
