/**
 * @file         : DataModelHomeTypes.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : DataModelHome is to handle model implementation of HomeScreen
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef _DataModelHomeTypes_H
#define _DataModelHomeTypes_H

#include "HomeScreenListInfoDefines.h"
#include "ApplicationSwitchConst.h"
#include <map>
#include <asf/core/Types.h>

enum enGadgetItemIndex
{
   GADGET_ITEM_INDEX_INVALID      = 0
   , GADGET_ITEM_INDEX_MEDIA      = 1
   , GADGET_ITEM_INDEX_TUNER      = 2
   , GADGET_ITEM_INDEX_PHONE      = 3
   , GADGET_ITEM_INDEX_NAVIGATION = 4
   , GADGET_ITEM_INDEX_CONNECT    = 5
   , GADGET_ITEM_INDEX_CAMERA     = 6
   , GADGET_ITEM_INDEX_MAPOUT     = 7
   , GADGET_ITEM_INDEX_SXM        = 8
};


enum enRegionItem
{
   EUR = 0,
   NAM = 1,
   TUR = 2,
   ISR = 3,
   GCC = 4,
   RES1 = 5,
   RES2 = 6,
   RES3 = 7,
   RES4 = 8,
   RES5 = 9,
   RES6 = 10,
   RES7 = 11,
   RES8 = 12,
   RES9 = 13,
   RES10 = 14,
   SNA = 15
};


enum enAnimationStatus
{
   ANIMATION_NONE         = 0
   , ANIMATION_STARTED     = 1
   , ANIMATION_COMPLETED   = 2
};


class HomeListItemInfo
{
   public:
      HomeListItemInfo()
      {
         resetData();
      }

      virtual ~HomeListItemInfo()
      {
         resetData();
      }

      HomeListItemInfo(const HomeListItemInfo& obj)
      {
         resetData();
         *this = obj;
      }

      HomeListItemInfo& operator= (const HomeListItemInfo& obj)
      {
         if (this != (&obj))
         {
            resetData();
            _isGadgetVisible             = obj.getGadgetVisibleStatus();
            _isGadgetActive              = obj.getGadgetActiveStatus();
            _gadgetBg                    = obj.getBitmapBg();
            _gadgetIconBgNormal          = obj.getBitmapIconNormalBg();
            _gadgetIconBgPressed         = obj.getBitmapIconPressedBg();
            _gadgetIcon                  = obj.getBitmapIcon();
            _gadgetDisabledBg            = obj.getDisabledBitmapBg();
            _gadgetDisabledIcon          = obj.getDisabledBitmapIcon();
            _gadgetDisabledTransparentBg = obj.getDisabledBitmapTransparentBg();
            _gadgetText                  = obj.getTouchAreaText();
            _gadgetDynamicText           = obj.getTouchAreaDynamicText();
            _gadgetTextColor             = obj.getTextColor();
            _gadgetTouchAreaBgNormal     = obj.getBitmaptouchAreaNormalBg();
            _gadgetTouchAreaBgPressed    = obj.getBitmaptouchAreaPressedBg();
            _gadgetInstanceId            = obj.getInstanceId();
            _gadgetMargin                = obj.getGadgetMargin();
            _gadgetFunctionNAMargin      = obj.getGadgetFunctionNAMargin();
            _gadgetLoadingIconMargin     = obj.getGadgetLoadingIconMargin();
            _gadgetSize                  = obj.getGadgetSize();
            _gadgetDataContext           = obj.getGadgetDataItemContext();
            _gadgetItemIndex             = obj.getItemIndex();
            _gadgetContentAvailable      = obj.getGadgetContentAvailable();
            _animationStatus             = obj.getAnimationStatus();
         }
         return (*this);
      }

      void resetData()
      {
         _isGadgetVisible             = false;
         _isGadgetActive              = false;
         _gadgetBg                    = "";
         _gadgetIconBgNormal          = "";
         _gadgetIconBgPressed         = "";
         _gadgetIcon                  = "";
         _gadgetDisabledBg            = "";
         _gadgetDisabledIcon          = "";
         _gadgetDisabledTransparentBg = "";
         _gadgetText                  = "";
         _gadgetDynamicText           = "";
         _gadgetTextColor             = Candera::Color(0.0, 0.0, 0.0);
         _gadgetTouchAreaBgNormal     = "";
         _gadgetTouchAreaBgPressed    = "";
         _gadgetInstanceId            = 0;
         _gadgetMargin                = Candera::Margin(0, 0, 0, 0);
         _gadgetFunctionNAMargin      = Candera::Margin(0, 0, 0, 0);
         _gadgetLoadingIconMargin     = Candera::Margin(0, 0, 0, 0);
         _gadgetSize                  = Candera::Vector2(0, 0);
         _gadgetDataContext           = "";
         _gadgetItemIndex             = GADGET_ITEM_INDEX_INVALID;
         _gadgetContentAvailable      = false;
         _animationStatus             = ANIMATION_NONE;
      }

      inline void setTextColour(const Candera::Color color)
      {
         _gadgetTextColor = color;
      }

      inline const Candera::Color&  getTextColor() const
      {
         return _gadgetTextColor;
      }

      inline void setTouchAreaText(const std::string& textId)
      {
         _gadgetText = textId;
      }

      inline const std::string& getTouchAreaText() const
      {
         return _gadgetText;
      }

      inline void setTouchAreaDynamicText(const std::string text)
      {
         _gadgetDynamicText = text;
      }

      inline const std::string getTouchAreaDynamicText() const
      {
         return _gadgetDynamicText;
      }

      inline void setBitmapBg(const std::string Bg)
      {
         _gadgetBg = Bg;
      }

      inline const std::string& getBitmapBg() const
      {
         return _gadgetBg;
      }

      inline void setBitmapTouchAreaNormalBg(const std::string touchAreaBg)
      {
         _gadgetTouchAreaBgNormal = touchAreaBg;
      }

      inline const std::string& getBitmaptouchAreaNormalBg() const
      {
         return _gadgetTouchAreaBgNormal;
      }

      inline void setBitmapTouchAreaPressedBg(const std::string touchAreaBg)
      {
         _gadgetTouchAreaBgPressed = touchAreaBg;
      }

      inline const std::string& getBitmaptouchAreaPressedBg() const
      {
         return _gadgetTouchAreaBgPressed;
      }

      inline void setBitmapIconNormalBg(const std::string iconBg)
      {
         _gadgetIconBgNormal = iconBg;
      }

      inline const std::string& getBitmapIconNormalBg() const
      {
         return _gadgetIconBgNormal;
      }

      inline void setBitmapIconPressedBg(const std::string iconBg)
      {
         _gadgetIconBgPressed = iconBg;
      }

      inline const std::string& getBitmapIconPressedBg() const
      {
         return _gadgetIconBgPressed;
      }

      inline void setBitmapIcon(const std::string icon)
      {
         _gadgetIcon = icon;
      }

      inline const std::string& getBitmapIcon() const
      {
         return _gadgetIcon;
      }

      inline void setDisabledBitmapBg(const std::string bg)
      {
         _gadgetDisabledBg = bg;
      }

      inline const std::string& getDisabledBitmapBg() const
      {
         return _gadgetDisabledBg;
      }

      inline void setDisabledBitmapIcon(const std::string icon)
      {
         _gadgetDisabledIcon = icon;
      }

      inline const std::string& getDisabledBitmapIcon() const
      {
         return _gadgetDisabledIcon;
      }

      inline void setDisabledBitmapTransparentBg(const std::string bg)
      {
         _gadgetDisabledTransparentBg = bg;
      }

      inline const std::string& getDisabledBitmapTransparentBg() const
      {
         return _gadgetDisabledTransparentBg;
      }

      inline void setInstanceId(const ::Courier::UInt32 id)
      {
         _gadgetInstanceId = id;
      }

      inline uint32 getInstanceId() const
      {
         return _gadgetInstanceId;
      }

      inline void setGadgetVisibleStatus(const bool status)
      {
         _isGadgetVisible = status;
      }

      inline bool getGadgetVisibleStatus() const
      {
         return _isGadgetVisible;
      }

      inline void setGadgetActiveStatus(const bool status)
      {
         _isGadgetActive = status;
      }

      inline bool getGadgetActiveStatus() const
      {
         return _isGadgetActive;
      }

      inline void setGadgetMargin(Candera::Margin margin)
      {
         _gadgetMargin = margin;
      }

      inline const Candera::Margin& getGadgetMargin() const
      {
         return _gadgetMargin;
      }

      inline void setGadgetFunctionNAMargin(Candera::Margin margin)
      {
         _gadgetFunctionNAMargin = margin;
      }

      inline const Candera::Margin& getGadgetFunctionNAMargin() const
      {
         return _gadgetFunctionNAMargin;
      }

      inline void setGadgetLoadingIconMargin(Candera::Margin margin)
      {
         _gadgetLoadingIconMargin = margin;
      }

      inline const Candera::Margin& getGadgetLoadingIconMargin() const
      {
         return _gadgetLoadingIconMargin;
      }

      inline void setGadgetSize(Candera::Vector2 size)
      {
         _gadgetSize = size;
      }

      inline const Candera::Vector2& getGadgetSize() const
      {
         return _gadgetSize;
      }

      inline void setGadgetDataItemContext(DataItemContext dataContext)
      {
         _gadgetDataContext = dataContext;
      }

      inline const DataItemContext& getGadgetDataItemContext() const
      {
         return _gadgetDataContext;
      }

      inline void setItemIndex(const enGadgetItemIndex id)
      {
         _gadgetItemIndex = id;
      }

      inline enGadgetItemIndex getItemIndex() const
      {
         return _gadgetItemIndex;
      }

      inline void setGadgetContentAvailable(const bool status)
      {
         _gadgetContentAvailable = status;
      }

      inline bool getGadgetContentAvailable() const
      {
         return _gadgetContentAvailable;
      }

      inline enAnimationStatus getAnimationStatus() const
      {
         return _animationStatus;
      }

      inline void setAnimationStatus(const enAnimationStatus status)
      {
         _animationStatus = status;
      }

   private:
      bool _isGadgetVisible;
      bool _isGadgetActive;
      bool _gadgetContentAvailable;
      enAnimationStatus _animationStatus;
      std::string _gadgetBg;
      std::string  _gadgetIconBgNormal;
      std::string  _gadgetIconBgPressed;
      std::string  _gadgetIcon;
      std::string  _gadgetDisabledBg;
      std::string  _gadgetDisabledIcon;
      std::string  _gadgetDisabledTransparentBg;
      std::string _gadgetText;
      std::string _gadgetDynamicText;
      Candera::Color _gadgetTextColor;
      std::string  _gadgetTouchAreaBgNormal;
      std::string  _gadgetTouchAreaBgPressed;
      uint32 _gadgetInstanceId;
      Candera::Margin _gadgetMargin;
      Candera::Margin  _gadgetFunctionNAMargin;
      Candera::Margin  _gadgetLoadingIconMargin;
      Candera::Vector2 _gadgetSize;
      DataItemContext _gadgetDataContext;
      enGadgetItemIndex _gadgetItemIndex;
} ;


namespace App {
namespace datamodel {

class HomeListInfo
{
   public:
      HomeListInfo()
      {
         resetData();
      }

      virtual ~HomeListInfo()
      {
         resetData();
      }

      HomeListInfo(uint32 regionId, uint32 viewId, ::std::vector< HomeListItemInfo > info)
      {
         _regionId           = regionId;
         _viewId             = viewId;
         _listItemInfoVector = info;
      }

      HomeListInfo(const HomeListInfo& obj)
      {
         resetData();
         *this = obj;
      }

      HomeListInfo& operator= (const HomeListInfo& obj)
      {
         if (this != (&obj))
         {
            resetData();
            _regionId           = obj._regionId;
            _viewId             = obj._viewId;
            _listItemInfoVector = obj._listItemInfoVector;
         }
         return (*this);
      }

      void resetData()
      {
         _regionId          = REGION_INVALID;
         _viewId            = M1_Scenes_MasterHome;
         _listItemInfoVector.clear();
      }

      uint32 _regionId;
      uint32 _viewId;
      tSharedPtrDataProvider _dataProvider;
      ::std::vector< HomeListItemInfo > _listItemInfoVector;
};


} //namespace DataModel
} //namespace App


#endif /* _DataModelHome_H */
