/**
 * @file         : DataModelHome.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : DataModelHome is to handle model implementation of HomeScreen
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef _DATAMODELHOME_H
#define _DATAMODELHOME_H

#include "AppHmi_MasterStateMachine.h"
#include "DataModelHomeTypes.h"
#include <App/Core/Utility/MasterUtility.h>
#include <CgiExtensions/DataBindingItem.hpp>
#include <Common/DataModel/ListRegistry.h>
#include <Common/VehicleConfigurationReader/VehicleConfigurationReader.h>
#include <App/Core/VariantHandling/VariantHandling.h>
#include <Core/RegionHandling/RegionHandlingInterface.h>
#include <Core/CabinConnectionHandler/CabinConnectionHandlerInterface.h>
#include <Core/HmiInfoService/HmiInfoServiceServerComponentHandlingInterface.h>
#include <Core/ContextSwitchHandler/ContextSwitchHandlerInterface.h>

/**
 *  Classes Forward Declaration
 */
#define INIT 0
#define FUN_NOT_AVAIL 1
#define MAP_NOT_SUP 2
#define MAPOUT_ID 0


namespace App {
namespace Core {

class CabinConnectionUtility;
} //namespace Core
} //namespace App

namespace App {
namespace datamodel {


class DataModelHome: public ListImplementation
   , public ::App::Core::IMixSrcConnectionStatus
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
   , public ::App::Core::IMapOutStatusListenerCB
#endif
   , public ::App::Core::ICMAStatusListenerCB
   , public ::App::Core::ICMGStatusListenerCB
   , public ICabinVideoMixIndexListener
   , public ISpiDeviceInfoListenerCB
   , public ::App::Core::IMarketRegionValue
{
   public:
      virtual ~DataModelHome();
      static void deleteInstance();
      static DataModelHome& getInstance();
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      void updateDirectTextureRender(int sinkId, int srcId);
      void initListInfo();
      void intialize();
      void finalize();
      void onCMAStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onCMGStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onVideoMixIndexUpdate(const uint32 regionId, const uint8 videoMixIndex, const uint8 reason);
      void onDeviceInfoUpdate(const std::string deviceName, const uint8 deviceType, const uint8 deviceStatus);
      void currentMixSourceConnectionStatus(const int16 sourceId, const bool status, const int16 sinkId, int mixSourceIndex);
      void updateRegionStatusValue(const uint8);
      bool isMapoutSupported();
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
      void onMapOutStatusUpdate(const uint32 regionId, const ::App::Core::SinksMapOutInfo& info);
#endif
      inline void setRegionHandling(::App::Core::IRegionHandling& imp)
      {
         _regionHandling = (&imp);
      }

      inline void setVariantHandling(::App::Core::VariantHandling* imp)
      {
         _variantHandler = imp;
      }
      inline void setHmiInfoServiceServerComponent(IHmiInfoServiceServerComponent& imp)
      {
         _hmiInfoServiceServerComponent = (&imp);
      }

      inline void setCabinConnectionHandler(::App::Core::ICabinConnectionHandler& imp)
      {
         _cabinConnectionHandler = (&imp);
      }

      inline void setContextSwitchHandler(::App::Core::IContextSwitchHandler& imp)
      {
         _contextSwitchHandler = (&imp);
      }

      inline void setCabinConnectionUtility(::App::Core::CabinConnectionUtility& imp)
      {
         _cabinConnectionUtility = (&imp);
      }

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MASTER_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(SceneStatusInfoMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(AnimationWidgetIndMsg)
      ON_COURIER_MESSAGE(DataModelHomeListUpdateReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::ProviderUpdateIndicationMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

   private:
      DataModelHome();
      DataModelHome(const DataModelHome& obj);
      DataModelHome& operator= (const DataModelHome& obj);
      tSharedPtrDataProvider getListDataProviderLeftList(::Courier::UInt32 currentListID);
      tSharedPtrDataProvider getListDataProviderRightList(::Courier::UInt32 currentListID);
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const SceneStatusInfoMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const AnimationWidgetIndMsg& oMsg);
      bool onCourierMessage(const DataModelHomeListUpdateReqMsg& oMsg);
      bool onCourierMessage(const hmibase::gadget::ProviderUpdateIndicationMsg& oMsg);
      bool isViewVisible(const uint32 viewId);
      bool isGlassA2Configured(const uint32 regionId);
      bool isGlassSystemsValid(const uint32 regionId, const uint8 systemGroupCategory);
      void activateDeactivateGadgets(const uint32 viewId, const uint32 status);
      void activateDeactivateGadgetsForList(const uint32 listId, const uint32 status);
      void updateSceneStatus(const uint32 viewId, const enSceneStatus status);
      void performSubSystemUpdate(const bool update = false);
      void updateMapOutTile(const uint32 listId, const bool update);
      void resetDataProviders(const uint32 viewId);
      void performGadgetActiveStatus(const uint32 gadgetInstanceId, const uint32 regionId, const bool status);
      void activateDeactivateMapoutCabin();
      void performGadgetVisibilityStatus(const uint32 gadgetInstanceId, const uint32 regionId, const bool status, const bool update = false);
      void getGadgetInfoFromDP();
      void setGadgetInfoToDP(uint32 gadget, uint32 regionId);
      bool isLastActiveGadget(uint32 gadgetId, uint32 regionId) const;
      ::std::map< uint32, HomeListInfo > const getSmartListInfo() const;
      ::std::map< uint32, HomeListInfo > const getCoachListInfo()const;
      ::std::map< uint32, HomeListInfo > const getTruckListInfo()const;
      HomeListInfo* getHomeListInfo(const uint32 listId);
      void onCMADisConnectedUpdate(const uint32 regionId, const bool update);
      void onCMAConnectedUpdate(const uint32 regionId, const bool update);
      void onCMANoneUpdate(const uint32 regionId, const bool update);
      bool isRegionViewVisible(const uint32 regionId);
      void updateListContent(const uint32 listId, const ::std::vector< uint32 >& hdlInfo);
      void updateLeftListContent(const uint32 listId, const ::std::vector< uint32 >& hdlInfo);
      void updateRightListContent(const uint32 listId, const ::std::vector< uint32 >& hdlInfo);
      void updateLeftListItem(ListDataProviderBuilder::ListItem* listItem, HomeListItemInfo& homeListItemInfo, const uint32 regionId);
      void updateRightListItem(ListDataProviderBuilder::ListItem* listItem, HomeListItemInfo& homeListItemInfo, const uint32 regionId);
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
      void updateMapoutTileonCMGUnavailable();
      const char* getMapOutStatusString(const uint8 mapOutStatus);
      uint8 getMapOutStatus(const uint32 regionId) const;
      uint8 getVideoMixIndex(const uint32 regionId) const;
      void updateCabinMapOut(::Courier::DataItemContainer<HomescreenGadgetInfoDataBindingSource>* listItemData, const HomeListItemInfo& homeListItemInfo, const uint32 regionId);
      void updateCabinMixMapOut(ListDataProviderBuilder::ListItem* listItem,
                                ::Courier::DataItemContainer<HomescreenGadgetInfoDataBindingSource>* listItemData, const HomeListItemInfo& homeListItemInfo, const uint32 regionId);
#endif /* VARIANT_S_FTR_ENABLE_MAP_STREAMING */

      static DataModelHome* _theModelInstance;
      ::App::Core::VariantHandling* _variantHandler;
      ::App::Core::IRegionHandling* _regionHandling;
      ::App::Core::CabinConnectionUtility* _cabinConnectionUtility;
      IHmiInfoServiceServerComponent* _hmiInfoServiceServerComponent;
      ::App::Core::ICabinConnectionHandler* _cabinConnectionHandler;
      ::App::Core::IContextSwitchHandler* _contextSwitchHandler;
      ::std::map <uint32, enSceneStatus> _sceneStatus;
      ::std::map< uint32, HomeListInfo > _homeListInfo;
      DataBindingItem<MicCabinStatusDataBindingSource> m_MICIconCabinData;
      DataBindingItem<WidgetControllersDataBindingSource> m_WidgetControllersData;
      DataBindingItem<CockpitCabinContextDataBindingSource> _CockpitCabinContextData;
      uint32 m_u32CockpitLastActiveAudioGadgetInfo;
      uint32 m_u32CabinALastActiveAudioGadgetInfo;
      uint32 m_u32CabinBLastActiveAudioGadgetInfo;
      uint16 _variantType;
      uint8 _regionValue;
};


} //namespace DataModel
} //namespace App


#endif /* _DataModelHome_H */
