/* ***************************************************************************************
* FILE:          DataModelPower.h
* SW-COMPONENT:  APPHMI_MASTER
*  DESCRIPTION:  DataModelPower.h is part of HMI-Master application data model
*    COPYRIGHT:  (c) 2020-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _DataModelPower_H
#define _DataModelPower_H

#include "asf/core/Types.h"
#include "AppHmi_MasterStateMachine.h"
#include "App/Core/VariantHandling/VariantHandling.h"
#include "App/Core/VehicleSrvClient/IVehicleSrvClientInterface.h"

namespace App {
namespace Core {

class VariantHandling;
class IHmiStateHandler;
class RearViewCamera;
class IRegionHandling;
} //namespace Core
} //namespace App

namespace App {
namespace datamodel {

class DataModel;
class DataModelSound;
class DataModelPower : public ::App::Core::IRadioPwrCommandValueUpdateListenerCB
{
   public:
      virtual ~DataModelPower();
      static void deleteInstance();
      static DataModelPower& getInstance();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MASTER_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(HKStatusUpdateMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();
      void onRadioCommandValueUpdate(const uint8 RadioCmndValue);

      inline void setVariantHandling(::App::Core::VariantHandling& imp)
      {
         _variantHandling = (&imp);
      }

      inline void setRegionHandling(::App::Core::IRegionHandling& imp)
      {
         _regionHandling = (&imp);
      }

      inline void setDataModelSound(DataModelSound& imp)
      {
         _dataModelSound = (&imp);
      }

      inline void setDataModel(DataModel& imp)
      {
         _dataModel = (&imp);
      }

      inline void setHMIStateHandler(::App::Core::IHmiStateHandler& imp)
      {
         _hmiStateHandler = (&imp);
      }

      inline void setRearViewCamera(::App::Core::RearViewCamera& imp)
      {
         _rearViewCamera = (&imp);
      }

      inline void initialize()
      {
         if (NULL != _vehicleSrvClient)
         {
            _vehicleSrvClient->addRadioPwrCommandListener((*this));
         }
      }

      inline void finalize()
      {
         if (NULL != _vehicleSrvClient)
         {
            _vehicleSrvClient->removeRadioPwrCommandListener((*this));
         }
      }

      inline void setVehicleSrvClientInstance(::App::Core::IVehicleSrvClient& imp)
      {
         _vehicleSrvClient = (&imp);
      }

   private:
      DataModelPower();
      DataModelPower(const DataModelPower& obj);
      DataModelPower& operator= (const DataModelPower& obj);
      bool onCourierMessage(const HKStatusUpdateMsg& oMsg);
      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);
      void updateHardKeyState(uint8 hkState);
      void handleHMIStateON(uint8 hkState);
      void handleHMIStateOff(uint8 hmistate, uint8 hkState) const;
      void handleHMIStateRemoteProgramming(uint8 hkState) const;
      void toggleSPMState() const;
      void updateGpioOnOffState()const;
      void performSPMStateChange() const;
      /**
       *  Member Variables Declaration
       */
      enum hardKeyStatusOnPowerButton
      {
         HKPOWERBUTTON_NONE = 0,
         HKPOWERBUTTON_MUTE = 1,
         HKPOWERBUTTON_USEROFF = 2,
         HKPOWERBUTTON_CONTEXTSWITCH = 3,
         HKPOWERBUTTON_REGIONSWITCH = 4,
         HKPOWERBUTTON_STANDBY = 5,
         HKPOWERBUTTON_REBOOT = 6
      };

      hardKeyStatusOnPowerButton _powerKeyState;
      static DataModelPower* _theModelInstance;
      ::App::Core::VariantHandling* _variantHandling;
      ::App::Core::IRegionHandling* _regionHandling;
      DataModelSound* _dataModelSound;
      DataModel* _dataModel;
      ::App::Core::IHmiStateHandler* _hmiStateHandler;
      ::App::Core::RearViewCamera* _rearViewCamera;
      ::App::Core::IVehicleSrvClient* _vehicleSrvClient;

      uint16 variantType;
      uint16 targetType;
};


}
}


#endif /* _DataModelpower_H */
