/* ***************************************************************************************
* FILE:          DataModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataModel.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _DATAMODEL_H_
#define _DATAMODEL_H_


#include <App/DataModel/Home/DataModelHome.h>
#include <App/Core/VehicleSrvClient/VehicleSrvClient.h>
#include <App/Core/Diagnosis/diagnosisClientHandler.h>
#include <App/Core/RegionHandling/RegionHandlingInterface.h>
#include <CgiExtensions/DataBindingItem.hpp>

#define APPLICATIONSWITCH_TYPES    ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch

using namespace Courier;

/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {

class IContextSwitchHandler;
} //namespace Core
} //namespace App

namespace App {
namespace datamodel {

class DataModel
{
   public:

      static DataModel& getInstance()
      {
         return *_theInstance;
      }
      static void Init();
      virtual ~DataModel();

      inline void setContextSwitchHandler(::App::Core::IContextSwitchHandler& imp)
      {
         _contextSwitchHandler = (&imp);
      }

      inline void setRegionHandling(::App::Core::IRegionHandling& imp)
      {
         _regionHandling = (&imp);
      }

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(StartDisclaimerTimerReqMsg)
      ON_COURIER_MESSAGE(StopDisclaimerTimerReqMsg)
      ON_COURIER_MESSAGE(HandleSettingsMsg)
      ON_COURIER_MESSAGE(HKStatusUpdateMsg)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
#ifdef VARIANT_S_FTR_ENABLE_ANTI_THEFT
      ON_COURIER_MESSAGE(ReqHMIReadVIN)
      ON_COURIER_MESSAGE(UpdateVINStatus)
#endif
      COURIER_MSG_MAP_END()

      bool isMasterApplicationForeground() const;
#ifdef VARIANT_S_FTR_ENABLE_ANTI_THEFT
      uint8 u8GetAntiTheftStatus();
#endif
      void updateKDSValueToModel(uint8 kdsStatus);
      void UpdateCoachCabinContext(int context);
      void performHomeScreenContextSwitch(uint32 regionID) const;
      void performHomeScreenRegionSwitch() const;
   private:

      DataModel();
      static DataModel* _theInstance;
      DataBindingItem<KDSStatusInfoDataBindingSource> m_KDSStatusData;

      ::App::Core::IRegionHandling* _regionHandling;
      ::App::Core::IContextSwitchHandler* _contextSwitchHandler;

      Util::Timer _timer;
      bool _appMasterForeground;
#ifdef VARIANT_S_FTR_ENABLE_ANTI_THEFT
      uint8 _u8AntiTheftStatus;
#endif
      bool onCourierMessage(const StartDisclaimerTimerReqMsg& oMsg);
      bool onCourierMessage(const StopDisclaimerTimerReqMsg& oMsg);
      bool onCourierMessage(const HandleSettingsMsg& oMsg);
      bool onCourierMessage(const HKStatusUpdateMsg& oMsg);
      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);
#ifdef VARIANT_S_FTR_ENABLE_ANTI_THEFT
      bool onCourierMessage(const ReqHMIReadVIN& oMsg);
      bool onCourierMessage(const UpdateVINStatus& oMsg);
#endif
};


DataModelHome& getDM();
}


}

#endif // _DATAMODEL_H_
