/**************************************************************************************
 * @file         : UserInterfaceHandler.cpp
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : UserInterfaceHandler is to manage keys registration
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/


#include "UserInterfaceHandler.h"
#include "hmi_trace_if.h"
#include "ProjectBaseTypes.h"
#include "App/Core/Utility/MasterUtility.h"
#include "App/Core/KeyRouter/KeyRouterTypes.h"
#include <App/Core/HmiAppCtrl/IHmiAppCtrlAppInfoInterface.h>


#define APPHMI_SPI	1175


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MASTER_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MASTER
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_MASTER_"
#define ETG_I_FILE_PREFIX                 App::Core::UserInterfaceHandler::UserInterfaceHandler::
#include "trcGenProj/Header/UserInterfaceHandler.cpp.trc.h"
#endif


using namespace ::keyRouter;
using namespace ::keyRouterTypes;


namespace App {
namespace Core {


UserInterfaceHandler::UserInterfaceHandler() : _appInfoImpl(NULL)
{}


UserInterfaceHandler::~UserInterfaceHandler()
{
   _appInfoImpl = NULL;
}


int UserInterfaceHandler::getHardKeyRegisteredApp(const KeyInfo< uint32 >& hardKeyInfo)
{
   int regApp = APPID_APPHMI_UNKNOWN;
   switch (hardKeyInfo.getCode())
   {
      case HARDKEYCODE_HK_HOME_CABIN:
      case HARDKEYCODE_HK_HOME:
      case HARDKEYCODE_HK_MAP:
      case HARDKEYCODE_HK_SRC_COCKPIT:
      case HARDKEYCODE_HK_SRC_CABIN:
      case HARDKEYCODE_HK_POWER:
      case HARDKEYCODE_SWC_VOLUME_DOWN:
      case HARDKEYCODE_SWC_VOLUME_UP:
      case HARDKEYCODE_HK_CABIN_SETTINGS:
      {
         regApp = APPID_APPHMI_MASTER;
      }
      break;
      case HARDKEYCODE_HK_PHONE_ACCEPT:
      case HARDKEYCODE_HK_PHONE_REJECT:
      case HARDKEYCODE_SWC_PHONE_PICKUP:
      case HARDKEYCODE_SWC_PHONE_REJECT:
      case HARDKEYCODE_REMOTECONTROL_VOICE:
      {
         regApp = getRegisterdAppForPhnKeys(hardKeyInfo.getPidSender(), hardKeyInfo.getUserData());
      }
      break;
      case HARDKEYCODE_REMOTECONTROL_PHONE:
      {
         regApp = APPID_APPHMI_PHONE;
      }
      break;
      case HARDKEYCODE_HK_NAV:
      case HARDKEYCODE_REMOTECONTROL_TRAFFIC:
      case HARDKEYCODE_REMOTECONTROL_NAVI:
      {
         regApp = APPID_APPHMI_NAVIGATION;
      }
      break;
      case HARDKEYCODE_HK_MCP_MON_CABIN:
      {
         if ((hardKeyInfo.getUserData() > 0) || ((hardKeyInfo.getUserData() == 0) && (_appInfoImpl->getApplicationNameForPid(hardKeyInfo.getPidSender()) == "AppHmi_Master")))
         {
            regApp = APPID_APPHMI_SYSTEM;
         }
         else
         {
            regApp = APPID_APPHMI_MASTER;
         }
      }
      break;
      case HARDKEYCODE_HK_CAMERA:
      {
         regApp = APPID_APPHMI_CAMERA;
      }
      break;
      case HARDKEYCODE_REMOTECONTROL_MEDIA:
      {
         regApp = APPID_APPHMI_MEDIA;
      }
      break;
      case HARDKEYCODE_REMOTECONTROL_TUNER:
      {
         regApp = APPID_APPHMI_TUNER;
      }
      break;
      default:
         break;
   }
   return regApp;
}


int UserInterfaceHandler::getRegisterdAppForPhnKeys(int pid, int userData)
{
   int dp_VehicleType = App::Core::MasterUtility::getKDSVehicleType();
   int retvalue = 0;

   if (dp_VehicleType == VEHICLE_TYPE_SMART)
   {
      if ((userData == 0) && (NULL != _appInfoImpl) && (_appInfoImpl->getApplicationNameForPid(pid) == "AppHmi_SPI"))
      {
         retvalue = APPID_APPHMI_PHONE;
      }
      else
      {
         if (userData == 0)
         {
            retvalue = APPID_APPHMI_SPI;
         }
         else
         {
            retvalue = APPID_APPHMI_PHONE;
         }
      }
   }
   else
   {
      retvalue = APPID_APPHMI_PHONE;
   }

   return retvalue;
}


int UserInterfaceHandler::getEncoderRegisteredApp(const KeyInfo< int32 >& encoderInfo)
{
   int regApp = APPID_APPHMI_UNKNOWN;
   switch (encoderInfo.getCode())
   {
      case ENCCODE_LEFT_ENCODER:
      case ENCCODE_RIGHT_ENCODER:
      {
         regApp = APPID_APPHMI_MASTER;
      }
      break;
   }
   return regApp;
}


} //namespace App
} //namespace Core
