/**
 * @file         : SyncDisplayHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : SyncDisplayHandlerInterface is to handle the interface implementation of
 *                 feature SyncDisplayHandler
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef SYNC_DISPLAY_HANDLER_INTERFACE_H
#define SYNC_DISPLAY_HANDLER_INTERFACE_H


#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class VariantHandling;
class IHmiStateHandler;
class IHmiFirstAppListenerCB;
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ISyncDisplayHandler
{
   public:
      /**
       *  Member Function Declaration
       */
      ISyncDisplayHandler() {}
      virtual ~ISyncDisplayHandler() {}
      virtual bool getFirstAppRequestedStatus() const = 0;
      virtual void finalize() = 0;
      virtual void initialize() = 0;
      virtual void addHmiFirstAppListener(IHmiFirstAppListenerCB& imp) = 0;
      virtual void removeHmiFirstAppListener(IHmiFirstAppListenerCB& imp) = 0;
      virtual void setVariantHandling(VariantHandling& imp) = 0;
      virtual void setHMIStateHandler(IHmiStateHandler& imp) = 0;
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
      virtual void onMIC1StatusUpdate(const bool status) = 0;
#endif
      virtual void onGUIInitializationStatus(const bool status) = 0;
      virtual void sendFirstApplicationActiveUpdate() = 0;
};


class IHmiFirstAppListenerCB
{
   public:
      /**
       *  Member Functions Declaration
       */
      IHmiFirstAppListenerCB() {}
      virtual ~IHmiFirstAppListenerCB() {}
      virtual void onHmiFirstAppRequest() = 0;
};


}// namespace Core
}// namespace App


#endif /* SYNC_DISPLAY_HANDLER_INTERFACE_H */
