/**
 * @file         : SyncDisplayHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : SyncDisplayHandler is to handle HALL implementation for
 *                 Syncdisplay_main_fi service
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef SYNC_DISPLAY_HANDLER_H
#define SYNC_DISPLAY_HANDLER_H


#include "syncdisplay_main_fiProxy.h"
#include "SyncDisplayHandlerInterface.h"
#include <AppBase/StartupSync/StartupSync.h>
#include <App/Core/HmiState/HmiStateHandlerInterface.h>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class SyncDisplayHandler : public ISyncDisplayHandler
   , public ::asf::core::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public syncdisplay_main_fi::AnimationStatusCallbackIF
   , public syncdisplay_main_fi::SetFirstScreenReadyCallbackIF
   , public syncdisplay_main_fi::EarlyVideoLayerStatusCallbackIF
   , public IHmiStateListenerCB
{
   public:
      /**
       *  Member Functions Declaration
       */
      SyncDisplayHandler();
      virtual ~SyncDisplayHandler();
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onAnimationStatusError(const ::boost::shared_ptr< syncdisplay_main_fi::Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< syncdisplay_main_fi::AnimationStatusError >& error);
      void onAnimationStatusStatus(const ::boost::shared_ptr< syncdisplay_main_fi::Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< syncdisplay_main_fi::AnimationStatusStatus >& status);
      void onEarlyVideoLayerStatusError(const ::boost::shared_ptr< syncdisplay_main_fi::Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< syncdisplay_main_fi::EarlyVideoLayerStatusError >& error);
      void onEarlyVideoLayerStatusStatus(const ::boost::shared_ptr< syncdisplay_main_fi::Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< syncdisplay_main_fi::EarlyVideoLayerStatusStatus >& status);
      void onSetFirstScreenReadyError(const ::boost::shared_ptr< syncdisplay_main_fi::Syncdisplay_main_fiProxy >& /* proxy */, const ::boost::shared_ptr< syncdisplay_main_fi::SetFirstScreenReadyError >& /* error */) {}
      void onSetFirstScreenReadyResult(const ::boost::shared_ptr< syncdisplay_main_fi::Syncdisplay_main_fiProxy >& /* proxy */, const ::boost::shared_ptr< syncdisplay_main_fi::SetFirstScreenReadyResult >& /* result */) {}
      void onHmiStateUpdate(const uint8 hmiState);
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
      void onMIC1StatusUpdate(const bool status);
#endif
      void onGUIInitializationStatus(const bool status);
      void sendFirstApplicationActiveUpdate();

      inline bool getFirstAppRequestedStatus() const
      {
         return _isFirstAppRequested;
      }

      inline void setVariantHandling(VariantHandling& imp)
      {
         _variantHandling = (&imp);
      }

      inline void setHMIStateHandler(IHmiStateHandler& imp)
      {
         _hmiStateHandler = (&imp);
      }

      inline void initialize()
      {
         if (NULL != _hmiStateHandler)
         {
            _hmiStateHandler->addHmiStateListener(this);
         }
      }

      inline void finalize()
      {
         if (NULL != _hmiStateHandler)
         {
            _hmiStateHandler->removeHmiStateListener(this);
         }
      }

      inline void addHmiFirstAppListener(IHmiFirstAppListenerCB& imp)
      {
         ::std::vector< IHmiFirstAppListenerCB* >::const_iterator itr = ::std::find(_hmiFirstAppListeners.begin(), _hmiFirstAppListeners.end(), (&imp));
         if (itr == _hmiFirstAppListeners.end())
         {
            _hmiFirstAppListeners.push_back((&imp));
         }
      }

      inline void removeHmiFirstAppListener(IHmiFirstAppListenerCB& imp)
      {
         ::std::vector< IHmiFirstAppListenerCB* >::iterator itr = ::std::find(_hmiFirstAppListeners.begin(), _hmiFirstAppListeners.end(), (&imp));
         if (itr != _hmiFirstAppListeners.end())
         {
            (void)_hmiFirstAppListeners.erase(itr);
         }
      }

   private:
      /**
       *  Member Functions Declaration
       */
      uint8 getCurrentAnimationState() const;
      bool isHMIStateOnTel();
      bool isHMIStateHourLogic();
      bool isHMIStateRemoteProgramming();
      void sendShowTempHMIAppRequest();
      void sendShowFirstHMIAppRequest();
      /**
       *  Member Variables Declaration
       */
      bool _mic1Status;
      bool _isAnimationPlayed;
      bool _isFirstAppRequested;
      bool _guiInitializationStatus;
      bool _isLastHMIStateDiagnosis;
      act_t _regIdAnimationStatusUpdate;
      act_t _regIdEarlyVideoLayerUpdate;
      VariantHandling* _variantHandling;
      IHmiStateHandler* _hmiStateHandler;
      ::std::vector< IHmiFirstAppListenerCB* > _hmiFirstAppListeners;
      ::boost::shared_ptr< syncdisplay_main_fi::Syncdisplay_main_fiProxy > _syncDisplayProxy;
};


}// namespace Core
}// namespace App


#endif /* SYNC_DISPLAY_HANDLER_H */
