/**
 * @file         : RootContextHandler.cpp
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : RootContextHandler is to handle the root context (activity) information
 *                 i.e. Context (activity) which denotes beginning of the transition
 *                 always (EX: HomeScreen).
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#include "RootContextHandler.h"
#include "ApplicationSwitchConst.h"
#include <algorithm>


using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;


namespace App {
namespace Core {


RootContextHandler::RootContextHandler()
{
   clear();
   initRootContextsInfo();
}


RootContextHandler::~RootContextHandler()
{
   clear();
}


RootContextHandler::RootContextHandler(const RootContextHandler& obj)
{
   clear();
   *this = obj;
}


RootContextHandler& RootContextHandler::operator= (const RootContextHandler& obj)
{
   if (this != (&obj))
   {
      clear();
      _rootContextsInfo = obj._rootContextsInfo;
   }
   return (*this);
}


void RootContextHandler::initRootContextsInfo()
{
   if (_rootContextsInfo.empty())
   {
      _rootContextsInfo.push_back(enActivityIDs__eActivityID_HOME);
      _rootContextsInfo.push_back(enActivityIDs__eActivityID_CABINA_HOME);
      _rootContextsInfo.push_back(enActivityIDs__eActivityID_CABINB_HOME);
   }
}


bool RootContextHandler::isContextValidToClearStack(const uint32 contextId) const
{
   bool isValid = false;
   RootContextsInfo::const_iterator itr = ::std::find(_rootContextsInfo.begin(), _rootContextsInfo.end(), contextId);
   if (itr != _rootContextsInfo.end())
   {
      isValid = true;
   }
   return isValid;
}


} //namespace Core
} //namespace App
