/**************************************************************************************
* @file         : <RearViewCamera.cpp>
* @author       : <ECG> <INF4CV> Sathiya Jayanth Raman
* @addtogroup   :
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef REARVIEWCAMERA_H_
#define REARVIEWCAMERA_H_


#include "rvc_cca_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MasterMessages.h"
#include "AppHmi_MasterDatabinding.h"
#include "AppHmi_MasterStateMachine.h"
#include "Common/DataModel/ListRegistry.h"
#include "Widgets/2D/List/Data/ListDataProviderBuilder.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "App/Core/HmiInfoService/HmiInfoServiceServerComponent.h"

namespace App {
namespace Core {

class RearViewCamera : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::rvc_cca_fi::ReverseSignalStatusCallbackIF
   , public ::rvc_cca_fi::SetSystemStatusCallbackIF
   , public ::rvc_cca_fi::ToggleGpioPinOnOffCallbackIF
   , public ::rvc_cca_fi::SetRVCStatusCallbackIF
{
   public:

      void onToggleGpioPinOnOffState();
      static RearViewCamera* poGetInstance()
      {
         if (NULL == _RearViewClient)
         {
            _RearViewClient = new RearViewCamera();
         }

         return _RearViewClient;
      }

      virtual ~RearViewCamera();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onReverseSignalStatusError(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::ReverseSignalStatusError >& error);
      void onReverseSignalStatusStatus(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::ReverseSignalStatusStatus >& status);

      void onSetSystemStatusError(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::SetSystemStatusError >& error);

      void onSetSystemStatusResult(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::SetSystemStatusResult >& result);

      void onToggleGpioPinOnOffError(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::ToggleGpioPinOnOffError >& error);

      void onToggleGpioPinOnOffResult(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::ToggleGpioPinOnOffResult >& result);

      void onSetRVCStatusError(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::SetRVCStatusError >& error);

      void onSetRVCStatusResult(const ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ::rvc_cca_fi::SetRVCStatusResult >& result);

      void onActivateDeactivateRVC(bool status);

      void onRequestRVCbyNanoMessage(uint8 e8RequestState);

   private:

      RearViewCamera();
      static RearViewCamera* _RearViewClient;

      ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy > m_poRvcFiProxy;
};


}
}


#endif
