#include "NanoMsgClientHandler.h"
#include "hmi_trace_if.h"

#include "App/Core/RVCTestMode/RearViewCamera.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceConst.h"
#include "spm_core_fi_typesConst.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_MASTER_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_MASTER
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_MASTER_"
#define ETG_I_FILE_PREFIX App::Core::NanoMsgClientHandler::
#include "trcGenProj/Header/NanoMsgClientHandler.cpp.trc.h"
#endif

#define MIC2_MASK    ( 2 - 1 )
#define MIC3_MASK    ( 11 - 1 )
#define RVC_MASK     ( 4 -1 )
#define BITMASK   1

#define OFF  0
#define ON   1

using namespace ::bosch::cm::di::NanoMsgGenericInterface;

namespace App {
namespace Core {


NanoMsgClientHandler::NanoMsgClientHandler()
   : m_poNanoMsgProxy(bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy::createProxy("NanoMsgGenericPort", *this))
   , _regionHandling(NULL)
   , _hmiStateHandler(NULL)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler Constructor is called"));
   m_bMIC3Status = false;
   m_bMIC2Status = false;
}


NanoMsgClientHandler::~NanoMsgClientHandler()
{
}


void NanoMsgClientHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onAvailable()"));
   if ((m_poNanoMsgProxy.get()) && (m_poNanoMsgProxy == proxy) && (NULL != _regionHandling))
   {
      m_poNanoMsgProxy->sendSig_EventDigitalInputRegister(*this);
      m_poNanoMsgProxy->sendSig_RspGetDigitalInputRegister(*this);
      m_poNanoMsgProxy->sendReqGetDigitalInputRequest(*this, 2, 1, 22, (_regionHandling->getSystemIPAddress(SystemEnquiryInfo(REGION_CABIN_A, SYSTEM_CATEGORY_CMA, STATUS_CATEGORY_NONE))));
   }
}


void NanoMsgClientHandler::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onUnavailable()"));
   if (m_poNanoMsgProxy.get() && m_poNanoMsgProxy == proxy)
   {
      m_poNanoMsgProxy->sendSig_EventDigitalInputDeregisterAll();
      m_poNanoMsgProxy->sendSig_RspGetDigitalInputDeregisterAll();
   }
}


void NanoMsgClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("NanoMsgClientHandler register property is called"));
}


void NanoMsgClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("NanoMsgClientHandler deregister property is called"));
}


void NanoMsgClientHandler::onReqGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqGetDigitalInputError "));
}


void NanoMsgClientHandler::onReqGetDigitalInputResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputResponse >& response)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqGetDigitalInputResponse "));
}


void NanoMsgClientHandler::onReqSetAnnouncementOutError(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::ReqSetAnnouncementOutError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqSetAnnouncementOutError "));
}


void NanoMsgClientHandler::onReqSetAnnouncementOutResponse(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::ReqSetAnnouncementOutResponse >& response)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onReqSetAnnouncementOutResponse "));
}


void NanoMsgClientHandler::onSig_RspGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputError "));
}


void NanoMsgClientHandler::onSig_RspGetDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputSignal >& signal)
{
   uint32 digitalInput = signal->getDigitalInput();
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_RspGetDigitalInputSignal DigitalInput :%d", digitalInput));
   vUpdateMic2StatusByNanoMessage(digitalInput);
   vUpdateMic3StatusByNanoMessage(digitalInput);
   vActivateRVCByNanoMessage(digitalInput);
}


void NanoMsgClientHandler::onSig_EventDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputSignal >& signal)
{
   uint32 digitalInput = signal->getDigitalInput();
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_EventDigitalInputSignal DigitalInput :%d", digitalInput));
   vUpdateMic2StatusByNanoMessage(digitalInput);
   vUpdateMic3StatusByNanoMessage(digitalInput);
   vActivateRVCByNanoMessage(digitalInput);
}


void NanoMsgClientHandler::onSig_EventDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputError >& error)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::onSig_EventDigitalInputError "));
}


void NanoMsgClientHandler::vActivateRVCByNanoMessage(uint32 digitalInput)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::vActivateRVCByNanoMessage() :%d ", digitalInput));
   int32_t rvcStatus   = (digitalInput & (BITMASK << RVC_MASK)) ? ON : OFF ;
   ETG_TRACE_USR4(("NanoMsgClientHandler::vActivateRVCByNanoMessage RVCStatus :%d ,", rvcStatus));
   RearViewCamera::poGetInstance()->onRequestRVCbyNanoMessage(rvcStatus);
}


void NanoMsgClientHandler::vUpdateMic2StatusByNanoMessage(uint32 digitalInput)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::vUpdateMic2StatusByNanoMessage() :%d ", digitalInput));
   int32_t mic2Status_ = (digitalInput & (BITMASK << MIC2_MASK)) ? ON : OFF ;
   ETG_TRACE_USR4(("NanoMsgClientHandler::vUpdateMic2StatusByNanoMessage Mic2Status_ :%d ,", mic2Status_));
   if (mic2Status_ != m_bMIC2Status)
   {
      for (::std::vector< INanoMSGMic2StatusUpdCB* >::const_iterator itr = _mic2State.begin(); (itr != _mic2State.end()); ++itr)
      {
         if (NULL != (*itr))
         {
            (*itr)->onUpdateMic2Status(mic2Status_);
         }
      }
      m_bMIC2Status = mic2Status_;
      setSpmStateOnMixsourceReq();
   }
}


void NanoMsgClientHandler::vUpdateMic3StatusByNanoMessage(uint32 digitalInput)
{
   ETG_TRACE_USR4(("NanoMsgClientHandler::vUpdateMic3StatusByNanoMessage() :%d ", digitalInput));
   int32_t mic3Status_ = (digitalInput & (BITMASK << MIC3_MASK)) ? ON : OFF ;
   ETG_TRACE_USR4(("NanoMsgClientHandler::vUpdateMic3StatusByNanoMessage Mic3Status_ :%d ,", mic3Status_));

   if (mic3Status_ != m_bMIC3Status)
   {
      for (::std::vector< INanoMSGMic3StatusUpdCB* >::const_iterator itr = _mic3State.begin(); (itr != _mic3State.end()); ++itr)
      {
         if (NULL != (*itr))
         {
            (*itr)->onUpdateMic3Status(mic3Status_);
         }
      }
      m_bMIC3Status = mic3Status_;
      setSpmStateOnMixsourceReq();
   }
}


void NanoMsgClientHandler::setMic1AnnouncementRelay(const uint8 relayStatus)
{
   if ((m_poNanoMsgProxy.get()) && (NULL != _regionHandling))
   {
      m_poNanoMsgProxy->sendReqSetAnnouncementOutRequest(*this, static_cast<entAnnouncementState>(relayStatus), 2, 1, 32, (_regionHandling->getSystemIPAddress(SystemEnquiryInfo(REGION_CABIN_A, SYSTEM_CATEGORY_CMA, STATUS_CATEGORY_NONE))));
   }
}


void NanoMsgClientHandler::setSpmStateOnMixsourceReq()
{
   if (NULL != _hmiStateHandler)
   {
      ETG_TRACE_USR4(("NanoMsgClientHandler::setSpmStateOnMixsourceReq  %d", _hmiStateHandler->getHmiState()));
      if (m_bMIC2Status || m_bMIC3Status)
      {
         _hmiStateHandler->sendUserOnRequest(true);
      }
      else
      {
         _hmiStateHandler->sendUserOnRequest(false);
      }
   }
}


}
}
