/**
 * @file         : MediaClientHandlerTypes.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : MediaClientHandlerTypes is to handle the types implementation of
 *                 feature MediaClientHandler
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef MEDIA_CLIENT_HANDLER_TYPES_H
#define MEDIA_CLIENT_HANDLER_TYPES_H


#include <string>
#include <asf/core/Types.h>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class DeviceConnectionInfo
{
   public:
      /**
       *  Member Function Declaration
       */
      DeviceConnectionInfo()
      {
         clear();
      }

      virtual ~DeviceConnectionInfo()
      {
         clear();
      }

      DeviceConnectionInfo(const DeviceConnectionInfo& obj)
      {
         clear();
         *this = obj;
      }

      DeviceConnectionInfo& operator= (const DeviceConnectionInfo& obj)
      {
         if (this != (&obj))
         {
            clear();
            _id   = obj.getDeviceId();
            _type = obj.getDeviceType();
            _name = obj.getDeviceName();
         }
         return (*this);
      }

      inline void clear()
      {
         _id   = -1;
         _type = "";
         _name = "";
      }

      inline void setDeviceId(const int32 id)
      {
         _id = id;
      }

      inline int32 getDeviceId() const
      {
         return _id;
      }

      inline void setDeviceType(const ::std::string& type)
      {
         _type = type;
      }

      inline const ::std::string& getDeviceType() const
      {
         return _type;
      }

      inline ::std::string& getMutableDeviceType()
      {
         return _type;
      }

      inline void setDeviceName(const ::std::string& name)
      {
         _name = name;
      }

      inline const ::std::string& getDeviceName() const
      {
         return _name;
      }

      inline ::std::string& getMutableDeviceName()
      {
         return _name;
      }

   private:
      /**
       *  Member Function Declaration
       */
      int32 _id;
      ::std::string _type;
      ::std::string _name;
};


}// namespace Core
}// namespace App


#endif /* MEDIA_CLIENT_HANDLER_TYPES_H */
