/**
 * @file         : MediaClientHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : MediaClientHandler is to handle the service client implementation of
 *                 MediaPlayer services
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef MEDIA_CLIENT_HANDLER_H
#define MEDIA_CLIENT_HANDLER_H


#include "mplay_MediaPlayer_FIProxy.h"
#include "MediaClientHandlerInterface.h"
#include <AppBase/ServiceAvailableIF.h>
#include <AppBase/StartupSync/StartupSync.h>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class MediaClientHandler : public IMediaClientHandler
   , public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsCallbackIF
{
   public:
      /**
       *  Member Function Declaration
       */
      MediaClientHandler();
      virtual ~MediaClientHandler();
      bool fetchDeviceConnectionsInfo(::std::vector< DeviceConnectionInfo >& info);
      void registerDeviceConnectionsUpdate(IDeviceConnectionsCB& imp);
      void deregisterDeviceConnectionsUpdate(IDeviceConnectionsCB& imp);
      void onMediaPlayerDeviceConnectionsError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsError >& error);
      void onMediaPlayerDeviceConnectionsStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus >& status);

      inline void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
      {
         _guiInitialized = true;
         if ((NULL != _mediaPlayerProxy.get()) && (proxy == _mediaPlayerProxy))
         {
            registerDeviceConnectionsProperty();
         }
      }

      inline void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
      {
         if ((NULL != _mediaPlayerProxy.get()) && (proxy == _mediaPlayerProxy))
         {
            deregisterDeviceConnectionsProperty();
         }
      }
   private:
      /**
       *  Member Function Declaration
       */
      MediaClientHandler(const MediaClientHandler& obj);
      MediaClientHandler operator= (const MediaClientHandler& obj);
      ::std::vector< DeviceConnectionInfo > getDeviceConnectionsInfo(const ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus& info) const;

      inline void registerDeviceConnectionsProperty()
      {
         if ((NULL != _mediaPlayerProxy.get()) && (_guiInitialized) && (_regIdDeviceConnectionsUpdate == 0) && (!_deviceConnectionsCBInfo.empty()))
         {
            _regIdDeviceConnectionsUpdate = _mediaPlayerProxy->sendMediaPlayerDeviceConnectionsUpReg((*this));
         }
      }

      inline void deregisterDeviceConnectionsProperty()
      {
         if ((NULL != _mediaPlayerProxy.get()) && (_regIdDeviceConnectionsUpdate != 0))
         {
            _mediaPlayerProxy->sendMediaPlayerDeviceConnectionsRelUpReg(_regIdDeviceConnectionsUpdate);
            _regIdDeviceConnectionsUpdate = 0;
         }
      }
      /**
       *  Member Variables Declaration
       */
      bool _guiInitialized;
      act_t _regIdDeviceConnectionsUpdate;
      ::std::vector< IDeviceConnectionsCB* > _deviceConnectionsCBInfo;
      ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > _mediaPlayerProxy;
};


}// namespace Core
}// namespace App


#endif /* MEDIA_CLIENT_HANDLER_H */
