/**
 * @file         : MasterHall.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : MasterHall is to handle HALL / Model component features
 *                 instantiation and courier message delegation
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef MasterHall_h
#define MasterHall_h


#include "ProjectPluginMsgs.h"
#include "AppHmi_MasterMessages.h"
#include "AppHmi_MasterStateMachine.h"
#include <Common/PopupTimer/PopupTimer.h>
#include <Adapter/LanguageHandlerAdapter.h>
#include <AppHmi_MasterBase/AppHmi_MasterHallBase.h>
#include <Common/DefSetServiceBase/DefSetServiceBase.h>
#include "Common/DataModel/NavigationModeDBHandler.h"
#include "CgiExtensions/DataBindingItem.hpp"


/**
 *  Classes Forward Declaration
 */


namespace App {
namespace Core {


class VariantHandling;
class ISystemMonitorHandler;
class IRegionHandling;
class IHmiStateHandler;
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
class MasterGPIOHandler;
class INanoMsgClientHandler;
#endif /* VARIANT_S_FTR_ENABLE_MIC_ACTIVATION */
class ISyncDisplayHandler;
class IMediaClientHandler;
class IRootContextHandler;
class IContextSwitchHandler;
class diagnosisClientHandler;
class IContextPriorityHandler;
class IApplicationSurfaceInfoHandler;
class IApplicationSwitchServerComponent;
class HeatCtrlClientHandler;
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
class CabinConnectionUtility;
class ICabinConnectionHandler;
class ICabinRestorationHandler;
class ICabinVideoMixInfoDpHandler;
class ICabinsActivityInfoDpHandler;
#endif /* VARIANT_S_FTR_ENABLE_COACH_AUDIO */
} //namespace Core
} //namespace App

namespace App {
namespace datamodel {


#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
class DataModelSource;
class DataModelErrorPopup;
#endif
class DataModelControlPanel;
} //namespace datamodel
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class MasterHall : public hmibase::app::master::AppHmi_MasterHallBase
   , public iDefSetServiceBase
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      /**
       *  Member Functions Declaration
       */
      MasterHall();
      virtual ~MasterHall();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MASTER_COURIER_PAYLOAD_MODEL_COMP)
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
      ON_COURIER_MESSAGE(ActivateMIC)
#endif
      ON_COURIER_MESSAGE(ChangeRegionMsg)
      ON_COURIER_MESSAGE(StartBeepReqMsg)
      ON_COURIER_MESSAGE(DumpSystemsInfo)
      ON_COURIER_MESSAGE(UpdateSPM_HMI_ON)
      ON_COURIER_MESSAGE(SimHmiStateChange)
      ON_COURIER_MESSAGE(ShowHideRVCSceneMsg)
      ON_COURIER_MESSAGE(ReqSpeechSessionMsg)
      ON_COURIER_MESSAGE(Activate_Speech_Msg)
      ON_COURIER_MESSAGE(SimVideoMixIndexInfo)
      ON_COURIER_MESSAGE(ClearLastApplication)
      ON_COURIER_MESSAGE(HourLogicModeStateMsg)
      ON_COURIER_MESSAGE(EnableConnectionReqMsg)
      ON_COURIER_MESSAGE(SimSubSystemErrorStatus)
      ON_COURIER_MESSAGE(ContextSwitchFromHomeMsg)
      ON_COURIER_MESSAGE(FaciaON_OFF_Btn_ResetReqMsg)
      ON_COURIER_MESSAGE(ApplicationSwitchCompleteMsg)
      ON_COURIER_MESSAGE(PluginEntityDetailsUpdateMsg)
      ON_COURIER_MESSAGE(StoreContextSwitchFromHomeMsg)
      ON_COURIER_MESSAGE(ExecuteContextSwitchRequestMsg)
      ON_COURIER_MESSAGE(FaciaON_OFF_Btn_ShutDownReqMsg)
      ON_COURIER_MESSAGE(ApplicationSwitchCompleteUpdMsg)
      ON_COURIER_MESSAGE(FirstApplicationActivatedUpdMsg)
      ON_COURIER_MESSAGE(DumpContextSwitchStackInfo)
      ON_COURIER_MESSAGE(NavigationModeActiveMsg)
      ON_COURIER_MESSAGE(NavigationCarModeInfo)
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
      ON_COURIER_MESSAGE(MapOutStatusUpdMsg)
      ON_COURIER_MESSAGE(ToggleMapOutStatus)
#endif /* VARIANT_S_FTR_ENABLE_MAP_STREAMING */
      COURIER_MSG_MAP_DELEGATE_START()
      {
         delegateMessage(Msg);
      }
      COURIER_MSG_MAP_DELEGATE_END()

   protected:
      /**
       *  Member Functions Declaration
       */
      void initLanguageDpHandler();
      bool onChangeHmiSubStateReq() override;

   private:
      /**
       *  Member Functions Declaration
       */
      MasterHall(const MasterHall& obj);
      MasterHall& operator= (const MasterHall& obj);
      bool delegateMessage(const ::Courier::Message& Msg);
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
      bool onCourierMessage(const ActivateMIC& oMsg);
#endif
      bool onCourierMessage(const ChangeRegionMsg& oMsg);
      bool onCourierMessage(const StartBeepReqMsg& oMsg);
      bool onCourierMessage(const DumpSystemsInfo& oMsg);
      bool onCourierMessage(const UpdateSPM_HMI_ON& oMsg);
      bool onCourierMessage(const SimHmiStateChange& oMsg);
      bool onCourierMessage(const ShowHideRVCSceneMsg& oMsg);
      bool onCourierMessage(const ReqSpeechSessionMsg& oMsg);
      bool onCourierMessage(const Activate_Speech_Msg& oMsg);
      bool onCourierMessage(const ClearLastApplication& oMsg);
      bool onCourierMessage(const SimVideoMixIndexInfo& oMsg);
      bool onCourierMessage(const HourLogicModeStateMsg& oMsg);
      bool onCourierMessage(const EnableConnectionReqMsg& oMsg);
      bool onCourierMessage(const SimSubSystemErrorStatus& oMsg);
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& oMsg);
      bool onCourierMessage(const ContextSwitchFromHomeMsg& oMsg);
      bool onCourierMessage(const DumpContextSwitchStackInfo& oMsg);
      bool onCourierMessage(const FaciaON_OFF_Btn_ResetReqMsg& oMsg);
      bool onCourierMessage(const ApplicationSwitchCompleteMsg& oMsg);
      bool onCourierMessage(const PluginEntityDetailsUpdateMsg& oMsg);
      bool onCourierMessage(const StoreContextSwitchFromHomeMsg& oMsg);
      bool onCourierMessage(const FaciaON_OFF_Btn_ShutDownReqMsg& oMsg);
      bool onCourierMessage(const ExecuteContextSwitchRequestMsg& oMsg);
      bool onCourierMessage(const ApplicationSwitchCompleteUpdMsg& oMsg);
      bool onCourierMessage(const FirstApplicationActivatedUpdMsg& oMsg);
      bool onCourierMessage(const NavigationModeActiveMsg& oMsg);
      bool onCourierMessage(const NavigationCarModeInfo& oMsg);
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
      bool onCourierMessage(const MapOutStatusUpdMsg& oMsg);
      bool onCourierMessage(const ToggleMapOutStatus& oMsg);
#endif
      void finalize();
      void initialize();
      void createInstance();
      void deleteInstance();
      void finalizeAppFlyIn();
      void initializeAppFlyIn();
      void initializeDataModel();
      void finalizeDataModelHome();
      void finalizeRegionHandling();
      void finalizeDataModelSound();
      void initializeDataModelHome();
      void initializeDataModelSound();
      void initializeDataModelPower();
      void finalizeDataModelPower();
      void initializeRegionHandling();
      void initializeRearViewCamera();
      void initializeSyncDisplayHandler();
      void initializeSystemMonitorHandler();
      void finalizeDefSetServiceBase();
      void initializeDefSetServiceBase();
      void initializeDiagnosisClientHandler();
      void finalizeRearViewCamera();
      void finalizeDataModelControlPanel();
      void initializeSMExternalVariables();
      void initializeContextSwitchHandler();
      void initializeDataModelControlPanel();
      void initializeDataModelErrorPopop();
      void finalizeDataModelErrorPopop();
      void finalizeSoundConrollerPrj();
      void finalizeSystemMonitorHandler();
      void initializeSoundControllerPrj();
      void initializeConnectionControllerPrj();
      void finalizeSyncDisplayHandler();
      void initializeApplicationSwitchServerComponent();
      void reqPrepareResponse(const PrepareResDiagMsgData&);
      void reqExecuteResponse(const ExecuteResDiagMsgData&);
      void reqFinalizeResponse(const FinalizeResDiagMsgData&);
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
      void initializeDataModelSource();
      void finalizeDataModelSource();
      void initializeCabinConnectionHandler();
      void finalizeCabinConnectionHandler();
      void initializeCabinRestorationHandler();
      void finalizeCabinRestorationHandler();
      void initializeHmiInfoServiceServerComponent();
      void initializeCabinConnectionUtility();
#endif
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
      void initializeNanoMsgClientHandler();
      void initializeMasterGPIOHandler();
      void finalizeMasterGPIOHandler();
#endif

      /**
       *  Member Variables Declaration
       */
      IRegionHandling* _regionHandling;
      VariantHandling* _variantHandling;
      IHmiStateHandler* _hmiStateHandler;
      ISystemMonitorHandler* _systemMonitorHandler;
      ISyncDisplayHandler* _syncDisplayHandler;
      IMediaClientHandler* _mediaClientHandler;
      IRootContextHandler* _rootContextHandler;
      IContextSwitchHandler* _contextSwitchHandler;
      IContextPriorityHandler* _contextPriorityHandler;
      IApplicationSurfaceInfoHandler* _applicationSurfaceInfoHandler;
      ::App::datamodel::DataModelControlPanel* _dataModelControlPanel;
      IApplicationSwitchServerComponent* _applicationSwitchServerComponent;
      HeatCtrlClientHandler* _heatClientHandler;
      PopupTimerHandler::PopupTimer _mPopupTimer;
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
      INanoMsgClientHandler* _nanoMsgClientHandler;
      MasterGPIOHandler* _masterGPIOHandler;
#endif
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
      ::App::datamodel::DataModelSource* _dataModelSource;
      ::App::datamodel::DataModelErrorPopup* _dataModelErrorPopup;
      CabinConnectionUtility* _cabinConnectionUtility;
      ICabinConnectionHandler* _cabinConnectionHandler;
      ICabinRestorationHandler* _cabinRestorationHandler;
      ICabinVideoMixInfoDpHandler* _cabinVideoMixInfoDpHandler;
      ICabinsActivityInfoDpHandler* _cabinsActivityInfoDpHandler;
#endif
      NavigationModeDBHandler* _navigationModeDBHandler;
      DataBindingItem<CarModeVisibilityDataBindingSource> _carModeVisibilityStatus;
};


} //namespace Core
} //namespace App


#endif /* MasterHall_h */
