/**
 * @file         : MasterGui.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : INF4CV is to handle GUI / Model component features
 *                 instantiation and courier message delegation
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef MasterGui_h
#define MasterGui_h


#include "AppHmi_MasterTypes.h"
#include "AppBase/GuiComponentBase.h"
#include "AppBase/SystemConfiguration.h"
#include <App/Core/HmiAppCtrl/StubHandler_AppExt.h>
#include <App/Core/HmiAppCtrl/ProxyHandler_AppExt.h>
#include <App/Core/UserInterfaceHandler/UserInterfaceHandler.h>


/**
 *  Classes Forward Declaration
 */

class IlmClient;
class UserInterfaceHandler;


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class MasterGui
   : public GuiComponentBase
{
   public:
      /**
       *  Member Functions Declaration
       */
      MasterGui();
      virtual ~MasterGui();
      unsigned int getDefaultTraceClass();
      void preRun();
      void postRun();
      void setupCgiInstance();
      static void TraceCmd_DumpSystemsInfo();
      static void TraceCmd_VOLUME_DECREASE_CHANGE();
      static void TraceCmd_VOLUME_INCREASE_CHANGE();
      static void TraceCmd_DumpContextSwitchStackInfo();
      static void TraceCmd_KDS_UPDATE(uint8);
      static void TraceCmd_MIC_STATUS(const bool micStatus);
      static void TraceCmd_SimulateRVC(const bool rvcState);
      static void TraceCmd_ANTITHEFT_CHANGE(const uint8 status);
      static void TraceCmd_SYSTEMHEAT_POPUPSTATE(const int popupState);
      static void TraceCmd_SimHmiStateChange(const uint8 hmiState);
      static void TraceCmd_NotProcessedMsg(const unsigned char* pcu8Data);
      static void TraceCmd_onHourlogicpopupContext(const bool popupstatus);
      static void TraceCmd_MIC_ANNOUNCEMENT(const uint8 mic, const bool micStatus);
      static void TraceCmd_SimPluginEntityDetailsUpdate(const bool status, const ::std::string entityId);
      static void TraceCmd_SimHK(const HardKeyCodeEnum keyCode, const hmibase::HardKeyStateEnum keyState);
      static void TraceCmd_SimSubSystemErrorStatus(const enSystemCategory category, const uint8 systemId, const uint16 errorInfo);
      static void TraceCmd_SimVideoMixInfo(const enRegionID regionId, const enCabinVideoMixIndex videoMixIndex, const enCabinVideoMixChangeReason reason);
      static void TraceCmd_setNavigationModeActive(const bool carmode, const bool coachmode);

      COURIER_MSG_MAP_BEGIN(1)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(GuiComponentBase)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      /**
       *  Member Functions Declaration
       */
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);
      void configureHomeScreenGesture();
      /**
       *  Member Variables Declaration
       */
      IlmClient* _ilmClient;
      UserInterfaceHandler* _userInterfaceHandler;
      hmi::apphmi_master::StubHandler_AppExt hmiAppCtrlStubHandler;
      hmi::apphmi_master::ProxyHandler_AppExt _hmiAppCtrlProxyHandler;
};


}
}


#endif
