/**
 * @file         : MasterGPIOHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : MasterGPIOHandler is to handle ISR of MIC switch
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef MasterGpioHandler_H
#define MasterGpioHandler_H

#ifndef WIN32 /* Linux / Other OS env except Windows */
#include "pthread.h"
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include <stdio.h>
#include <sys/ioctl.h>
#include <linux/i2c.h>
#include <linux/i2c-dev.h>
#include <asf/core/Types.h>
#include <asf/core/Timer.h>

/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class MasterGPIOHandler
   : public ::asf::core::TimerCallbackIF
{
   public:
      /**
       *  Member Functions Declaration
       */
      MasterGPIOHandler();
      virtual ~MasterGPIOHandler();
      static OSAL_tpfGPIOCallback _pfCallbackGpioStateChange_MICSwitch(tVoid* pArg);
      static void postCourierMessage(bool);
      static void validateMICState(const bool);
      static void postMessageAndStartTimer(const bool);
#ifndef WIN32 /* Linux / Other OS env except Windows */
      static pthread_mutex_t _safeLock;
#endif

      tBool bGetMICSwitchStatus();
      tVoid _vCloseGpio_MICSwitch(tVoid);
      tVoid _vConfigureGpio_MICSwitch(tVoid);

      void onExpired(::asf::core::Timer& timer, ::boost::shared_ptr< ::asf::core::TimerPayload > data);

   private:
      /**
       *  Member Functions Declaration
       */
      MasterGPIOHandler(const MasterGPIOHandler& obj);
      MasterGPIOHandler& operator= (const MasterGPIOHandler& obj);
      /**
       *  Member Variables Declaration
       */
      static tBool m_bMICState;
      static tBool m_lastSentMicState;
      static ::asf::core::Timer* _debouncingTimer;
      static OSAL_tGPIODevID m_GpioId_MIC;
      static OSAL_tIODescriptor m_hGpioHandle_MIC;
};


} // namespace Core
} // namespace App


#endif
