/**************************************************************************************
 * @file         : KeyRouterTypes.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : KeyRouterTypes is to handle common types
 *                 (like defines, typedef ...)
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/


#ifndef KEYROUTER_TYPES_H
#define KEYROUTER_TYPES_H


#include "asf/core/Types.h"
#include "ProjectBaseTypes.h"


namespace keyRouterTypes {


/**
 *  Classes Declaration
 */

/**
 *  IKeyInfo is used to
 *   - Provide interface impl for KeyInfo.
 */
class IKeyInfo
{
   public:
      IKeyInfo() {}
      virtual ~IKeyInfo() {}
};


/**
 *  KeyInfo is used to
 *   - Hold basic informations of Key.
 */
template < typename CodeType >
class KeyInfo : public IKeyInfo
{
   public:
      /**
       *  Member Function Declaration
       */
      KeyInfo() : _actId(0)
         , _displayId(0)
         , _code(0)
         , _state(0)
         , _value(0)
         , _pidSender(0)
         , _pidReceiver(0)
         , _userData(0)
      { }

      KeyInfo(const act_t v1, const uint32 v2, const CodeType v3, const uint32 v4, const int32 v5, const uint32 v6, const uint32 v7, const uint32 v8) : _actId(v1)
         , _displayId(v2)
         , _code(v3)
         , _state(v4)
         , _value(v5)
         , _pidSender(v6)
         , _pidReceiver(v7)
         , _userData(v8)
      { }

      KeyInfo(const KeyInfo& obj)
      {
         clear();
         *this = obj;
      }

      virtual ~KeyInfo()
      {
         clear();
      }

      inline KeyInfo& operator = (const KeyInfo& obj)
      {
         if (this != &obj)
         {
            clear();
            _actId        = obj.getActId();
            _displayId    = obj.getDisplayId();
            _code         = obj.getCode();
            _state        = obj.getState();
            _value        = obj.getValue();
            _pidSender    = obj.getPidSender();
            _pidReceiver  = obj.getPidReceiver();
            _userData     = obj.getUserData();
         }
         return *this;
      }

      inline void clear()
      {
         _actId        = 0;
         _displayId    = 0;
         _code         = 0;
         _state        = 0;
         _value        = 0;
         _pidSender    = 0;
         _pidReceiver  = 0;
         _userData     = 0;
      }

      inline void setActId(const act_t id)
      {
         _actId = id;
      }

      inline act_t getActId() const
      {
         return _actId;
      }

      inline void setDisplayId(const uint32 id)
      {
         _displayId = id;
      }

      inline uint32 getDisplayId() const
      {
         return _displayId;
      }

      inline void setCode(const CodeType code)
      {
         _code = code;
      }

      inline CodeType getCode() const
      {
         return _code;
      }

      inline void setState(const uint32 state)
      {
         _state = state;
      }

      inline uint32 getState() const
      {
         return _state;
      }

      inline void setValue(const int32 value)
      {
         _value = value;
      }

      inline int32 getValue() const
      {
         return _value;
      }

      inline void setPidSender(const uint32 pidSender)
      {
         _pidSender = pidSender;
      }

      inline uint32 getPidSender() const
      {
         return _pidSender;
      }

      inline void setPidReceiver(const uint32 pidReceiver)
      {
         _pidReceiver = pidReceiver;
      }

      inline uint32 getPidReceiver() const
      {
         return _pidReceiver;
      }

      inline void setUserData(const uint32 userData)
      {
         _userData = userData;
      }

      inline uint32 getUserData() const
      {
         return _userData;
      }

   private:
      /**
       *  Member Variables Declaration
       */
      act_t _actId;
      uint32 _displayId;
      CodeType _code;
      uint32 _state; //Note: State is special handling only for HardKey
      int32 _value;
      uint32 _pidSender;
      uint32 _pidReceiver;
      uint32 _userData;
};


} //keyRouterTypes


#endif /* KEYROUTER_TYPES_H */
