/**************************************************************************************
 * @file         : IKeyRouterInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : IKeyRouterInterface is to provide interface impl for KeyRouter
 *                 (Dependency Breaker Strategy)
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/


#ifndef IKEYROUTER_H
#define IKEYROUTER_H


#include "KeyRouterTypes.h"


namespace keyRouter {


class IKeyRouterStubInterface;
class IKeyRouterUserInterface;
}


namespace hmi {
namespace apphmi_master {

class IHmiAppCtrlAppInfoInterface;
} //namespace apphmi_master
} //namespace hmi


namespace keyRouter {


class IKeyRouterInterface
{
   public:
      IKeyRouterInterface() { }
      virtual ~IKeyRouterInterface() { }
      virtual uint32 getDisplayId() const = 0;
      virtual void setDisplayId(const uint32 id) = 0;
      virtual void setKeyRouterId(const uint32 id) = 0;
      virtual void setKeyRouterStubImpl(IKeyRouterStubInterface* imp) = 0;
      virtual void setKeyRouterUserInterfaceImpl(IKeyRouterUserInterface* imp) = 0;
      virtual void setHmiAppCtrlAppInfoImpl(::hmi::apphmi_master::IHmiAppCtrlAppInfoInterface* imp) = 0;
      virtual void onHardKeyForwardingReq(const ::keyRouterTypes::KeyInfo< uint32 >& request) = 0;
      virtual void onEncoderForwardingReq(const ::keyRouterTypes::KeyInfo< int32 >& request) = 0;
};


} //namespace keyRouter


#endif /* IKEYROUTER_H */
