/**************************************************************************************
* @file         : ilm_client.h
* @author       :
* @addtogroup   : AppHmi_Master
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ILMCLIENT_H_
#define ILMCLIENT_H_


#include <vector>
#include <string>
#include <ilm/ilm_types.h>
#include <ilm/ilm_control.h>
#include "ProjectBaseTypes.h"


// ToDo : Display ID to be taken from ScreenLayouts xml
#if defined(GEN3X86) || defined(GEN4LSIM)
#define DISPLAY_ID 0
#else
#define DISPLAY_ID 1
#endif


enum SurfaceStates
{
   VISIBLE,
   VISIBLE_INPUT_KEY
};


enum SurfaceIdent
{
   SURFACE_ID,
   CREATOR_PID
};


class IlmClient
{
   public:
      IlmClient();
      virtual ~IlmClient();
      ilmErrorTypes init();
      void getVisibleSurfaceList(std::vector<int>& surfaceVector, const unsigned int displayId, int surfaceState = VISIBLE, int surfaceIdent = SURFACE_ID);
      void getVisibleSurfaceList(std::vector<int>& surfaceVector, int surfaceState = VISIBLE, int surfaceIdent = SURFACE_ID);
      static IlmClient* getInstance();
      bool surfaceAcceptsInput(t_ilm_surface surfaceId, ilmInputDevice inputDevice);
      std::string inputDeviceToString(ilmInputDevice inputDevice);
};


#endif /* ILMCLIENT_H_ */
