/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                  : HmiInfoServiceServerComponent.h
* COMPONENT Name        : AppHmi_Master
* DESCRIPTION           : DBus client for Application switch intrerface.
* AUTHOR                : Pushpa Talawar
* Date                  : 23.02.2018
* Revision History      : 0.1
* Date 23.08.2019       : Initial version
****************************************************************************/

#ifndef HMIINFOSERVICE_SERVER_COMPONENT_HEADER
#define HMIINFOSERVICE_SERVER_COMPONENT_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "HmiInfoService.h"
#include "HmiInfoServiceStub.h"
#include "HmiInfoServiceConst.h"
#include "AppHmi_MasterStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include <Core/LanguageHandlerInterface.h>
#include "HmiInfoServiceServerComponentHandlingInterface.h"


#define HMIINFOSERVICE_INTERFACE ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService


class HmiInfoServiceServerComponent : public HMIINFOSERVICE_INTERFACE::HmiInfoServiceStub
   , public IHmiInfoServiceServerComponent
   , public ::languageHandler::ILanguageStatusPropertyUpdateCB
{
   public:
      virtual ~HmiInfoServiceServerComponent();
      static HmiInfoServiceServerComponent* poGetInstance();
      uint8 getCabinVideoMixIndex(const uint32 regionId) const;
      void onLanguageStatusUpdate(const uint32 languageId);
      void sendAVRestorationSignal(const uint32 cabinId, const int16 sourceId);
      void onGetRVCSignalStatusRequest(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::GetRVCSignalStatusRequest >& request);
      void onToggleGadgetAudioSourceRequest(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::ToggleGadgetAudioSourceRequest >& request);
      void onSpiConnectionStatusInfoSet(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::SpiConnectionStatusInfoSet >& spiConnectionStatusInfo);
      void onGetCurrentForegroundApplicationIdRequest(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::GetCurrentForegroundApplicationIdRequest >& request);
      void onSetCabinSourceConnectionStatusRequest(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::SetCabinSourceConnectionStatusRequest >& request);
      void onRemoveCabinSourceConnectionRequest(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::RemoveCabinSourceConnectionRequest >& request);
      void sendRegionsMapOutStatusInfo();
      void sendRVCSignalUpdate(bool status);
      void sendForegroundApplicationUpdate(int appID);
      void sendCabinsSystemsInfoUpdate(const ::App::Core::SystemsInfoType& info);
      void sendCabinsSourceRestorationInfo(const ::App::Core::RestoreRegionsInfo& info);
      void addOrUpdateRegionsMapOutStatusInfo(const uint32 regionID, const uint32 glassID, const bool activeStatus);
      bool getCabinSourceStatus(const int16 srcID);
      void onSetCabinVideoMixIndexRequest(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::SetCabinVideoMixIndexRequest >& request);
      void setCabinVideoMixInfo(const CabinsVideoMixInfo& cabinVideoMixInfoUpdate);
      void onSetNavigationModeRequest(const ::boost::shared_ptr< HMIINFOSERVICE_INTERFACE::SetNavigationModeRequest >& request);
      void sendNavigationModeChangeSignal(const bool carModeActive, const bool coachModeActive);
      const HMIINFOSERVICE_INTERFACE::CabinVideoMixInfo* getVideoMixInfoForRegion(const uint32 regionId) const;

      inline void addSpiDeviceInfoListener(ISpiDeviceInfoListenerCB& imp)
      {
         ::std::vector< ISpiDeviceInfoListenerCB* >::const_iterator itr = ::std::find(_spiDeviceInfoListener.begin(), _spiDeviceInfoListener.end(), (&imp));
         if (itr == _spiDeviceInfoListener.end())
         {
            _spiDeviceInfoListener.push_back((&imp));
         }
      }

      inline void removeSpiDeviceInfoListener(ISpiDeviceInfoListenerCB& imp)
      {
         ::std::vector< ISpiDeviceInfoListenerCB* >::iterator itr = ::std::find(_spiDeviceInfoListener.begin(), _spiDeviceInfoListener.end(), (&imp));
         if (itr != _spiDeviceInfoListener.end())
         {
            (void)_spiDeviceInfoListener.erase(itr);
         }
      }

      inline void addCabinSourceStatusListener(ICabinSourceConnectionStatusCB& imp)
      {
         ::std::vector< ICabinSourceConnectionStatusCB* >::const_iterator itr = ::std::find(_cabinSouceStatusListener.begin(), _cabinSouceStatusListener.end(), (&imp));
         if (itr == _cabinSouceStatusListener.end())
         {
            _cabinSouceStatusListener.push_back((&imp));
         }
      }

      inline void removeCabinSourceStatusListener(ICabinSourceConnectionStatusCB& imp)
      {
         ::std::vector< ICabinSourceConnectionStatusCB* >::iterator itr = ::std::find(_cabinSouceStatusListener.begin(), _cabinSouceStatusListener.end(), (&imp));
         if (itr != _cabinSouceStatusListener.end())
         {
            (void)_cabinSouceStatusListener.erase(itr);
         }
      }

      inline void addVideoMixIndexListener(ICabinVideoMixIndexListener& imp)
      {
         ::std::vector< ICabinVideoMixIndexListener* >::const_iterator itr = ::std::find(_cabinVideoMixIndexListener.begin(), _cabinVideoMixIndexListener.end(), (&imp));
         if (itr == _cabinVideoMixIndexListener.end())
         {
            _cabinVideoMixIndexListener.push_back((&imp));
         }
      }

      inline void removeVideoMixIndexListener(ICabinVideoMixIndexListener& imp)
      {
         ::std::vector< ICabinVideoMixIndexListener* >::iterator itr = ::std::find(_cabinVideoMixIndexListener.begin(), _cabinVideoMixIndexListener.end(), (&imp));
         if (itr != _cabinVideoMixIndexListener.end())
         {
            (void)_cabinVideoMixIndexListener.erase(itr);
         }
      }

      inline void setCabinVideoMixInfoImpl(ICabinVideoMixInfoImpl& imp)
      {
         _cabinVideoMixInfoImpl = &imp;
      }

      inline const CabinsVideoMixInfo& getCabinsVideoMixInfo() const
      {
         const CabinsVideoMixInfo& cabinsVideoMixInfo = HmiInfoServiceStub::getCabinsVideoMixInfo();
         return cabinsVideoMixInfo;
      }

   private:
      HmiInfoServiceServerComponent();
      void updateCabinSouceStatusListeners();
      void updateVideoMixIndexListeners(CabinsVideoMixInfo& cabinsVideoMixInfo);
      void updateListeners(const std::string deviceName, const uint8 deviceType, const uint8 deviceStatus);

      static HmiInfoServiceServerComponent* m_poSelfHmiInfoServiceServer;
      ::std::vector< ISpiDeviceInfoListenerCB* > _spiDeviceInfoListener;
      ::std::vector<ICabinVideoMixIndexListener* > _cabinVideoMixIndexListener;
      ::std::vector<ICabinSourceConnectionStatusCB* > _cabinSouceStatusListener;

      ICabinVideoMixInfoImpl* _cabinVideoMixInfoImpl;
};


#undef HMIINFOSERVICE_INTERFACE

#endif
