/****************************************************************************
* Copyright (c) 2017-2019 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
****************************************************************************/

#ifndef HMI_HMI_MASTER_STUBHANDLER_APPEXT_H
#define HMI_HMI_MASTER_STUBHANDLER_APPEXT_H

#include "HMIAppCtrl/Stub/StubHandler.h"
#include "App/Core/KeyRouter/IKeyRouterStubInterface.h"
#include "App/Core/HmiAppCtrl/IHmiAppCtrlAppInfoInterface.h"
#include "ProjectBaseMsgs.h"
#include "ProjectBaseTypes.h" // enApplicationId

namespace hmi {
namespace apphmi_master {

// this is the specialized stub handler implementation
// mainly to extend the original StubHandler by key forwarding functionality for special keys
// and to establish a list of hmi application expected to be started
class StubHandler_AppExt : public hmibase::services::hmiappctrl::StubHandler,
   public ::keyRouter::IKeyRouterStubInterface,
   public IHmiAppCtrlAppInfoInterface
{
   public:
      StubHandler_AppExt();
      virtual ~StubHandler_AppExt() {};
      // project specific implementation of HMIAppCtrl callback
      ::std::string getApplicationNameForPid(const int pid) const;
      ::std::string getApplicationNameForAppId(const unsigned int appId) const;
      bool isAppPid(const int pid);
      int getPidOfApp(const int appId) const;
      unsigned int getApplicationId(const ::std::string& appName) const;
      void sendHardKeyInfoToBaseApp(const ::keyRouterTypes::KeyInfo< uint32 >& hardKeyInfo);
      void sendHardKeyInfoForwardingSig(const ::keyRouterTypes::KeyInfo< uint32 >& hardKeyInfo);
      void sendEncoderInfoToBaseApp(const ::keyRouterTypes::KeyInfo< int32 >& encCodeInfo);
      void sendEncoderInfoForwardingSig(const ::keyRouterTypes::KeyInfo< int32 >& encCodeInfo);
      void onKeyForwardingRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest >&);
      void onEncoderForwardingRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderForwardingRequest >& request);

      virtual void onSetApplicationMandatoryRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetApplicationMandatoryRequest >&);
};


}
}


#endif // HMI_HMI_MASTER_STUBHANDLER_APPEXT_H
