/****************************************************************************
* Copyright (c) 2017-2018 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.

****************************************************************************/

#include "hall_std_if.h"
#include "gui_std_if.h"

#include "ProxyHandler_AppExt.h"
#include "Project.h"
#include "AppBase/ScreenBrokerClient/ScreenBrokerClient.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_MASTER_MAIN
#include "trcGenProj/Header/ProxyHandler_AppExt.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl;

namespace hmi {
namespace apphmi_master {

void ProxyHandler_AppExt::onEvDisplayStatusEvalSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& /*proxy*/, const ::boost::shared_ptr< EvDisplayStatusEvalSignal >& statusEvalSignal)
{
   //ETG_TRACE_USR1((_myTraceID, "[[CLIENT %20s]] app id %d ProxyHandler::onEvDisplayStatusEvalEvent enter", _myName.c_str(), ScreenBrokerClient::GetInstance().AppId()));

   if (getpid() == statusEvalSignal->getData().getPidReceiver())
   {
      //ETG_TRACE_USR1((_myTraceID, "[[CLIENT %20s]] 'app id %d onEvDisplayStatusEvalEvent", _myName.c_str(), ScreenBrokerClient::GetInstance().AppId()));
   }
}


void ProxyHandler_AppExt::requestStatusLineCmd(std::string ApplicationName, int status)
{
   std::map<std::string, displayData*>::iterator itr;
   itr = mStatusLineTable.find(ApplicationName);
   if (itr != mStatusLineTable.end() && itr->second != NULL)
   {
      // change done for status line request for global soft key button with proper parameters
      _hmiAppCtrlProxy->sendDisplayCmdRequest(displayData(0, hmibase::app::base::appHmi_Master, hmibase::app::base::appHmi_Master, hmibase::STATUS_LINE, 0, status));
      _hmiAppCtrlProxy->sendDisplayCmdRequest(*(itr->second));
   }
   else
   {
      _hmiAppCtrlProxy->sendDisplayCmdRequest(displayData(0, hmibase::app::base::appHmi_Master, hmibase::app::base::appHmi_Master, hmibase::STATUS_LINE, 0, status));
   }
}


}
}
