/* ***************************************************************************************
* FILE:          diagnosisClientHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  diagnosisClientHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef DIAGNOSISCLIENTHANDLER_HEADER
#define DIAGNOSISCLIENTHANDLER_HEADER

/***********************************************************************
  INCLUDE FILES
 ***********************************************************************/
#include "AppHmi_MasterStateMachine.h"
#include "AppHmi_MasterDatabinding.h"
#include "AppHmi_MasterMessages.h"
#include "AppHmi_MasterConstants.h"
#include "AppHmi_MasterTypes.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "Midw_Diagnostics_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include <View/CGI/CgiExtensions/DataBindingItem.hpp>
//#include "../HmiState/HmiStateHandler.h"
#include "App/DataModel/DataModel.h"


/***********************************************************************
  Forward Class Declaration
 ***********************************************************************/

namespace App {
namespace datamodel {
class DataModel;
}


}

using namespace Midw_Diagnostics_FI ;
using namespace midw_diagnostics_fi_types;
using namespace std;
namespace App {
namespace Core {


class diagnosisClientHandler :
   public ::hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public Midw_Diagnostics_FI::RemoteControlCallbackIF,
   public Midw_Diagnostics_FI::ConfigUpdateViaUSBCallbackIF

#ifdef VARIANT_S_FTR_ENABLE_ANTI_THEFT
   ,
   public KdsEntryCallbackIF,
   public AntiTheftUnlockHMICallbackIF,
   public AntiTheftUnlockHUCallbackIF,
   public AntiTheftStatusCallbackIF
#endif
{
   public:
      diagnosisClientHandler();
      diagnosisClientHandler(::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >);
      virtual ~diagnosisClientHandler();

      inline void setDataModel(::App::datamodel::DataModel& imp)
      {
         _dataModelInstance = (&imp);
      }

      static diagnosisClientHandler* poGetInstance()
      {
         if (NULL == _diagnosisClientHandler)
         {
            _diagnosisClientHandler = new diagnosisClientHandler();
         }

         return _diagnosisClientHandler;
      }
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onRemoteControlError(const ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >& /*proxy*/, const ::boost::shared_ptr< Midw_Diagnostics_FI::RemoteControlError >& /*error*/);
      virtual void onRemoteControlStatus(const ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< Midw_Diagnostics_FI::RemoteControlStatus >& status);

      virtual void onConfigUpdateViaUSBError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ConfigUpdateViaUSBError >& error);
      virtual void onConfigUpdateViaUSBStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ConfigUpdateViaUSBStatus >& status);

#ifdef VARIANT_S_FTR_ENABLE_ANTI_THEFT

      virtual void onAntiTheftUnlockHMIError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHMIError >& error);

      virtual void onAntiTheftUnlockHMIStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHMIStatus >& status);

      virtual void onAntiTheftUnlockHUError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHUError >& error);

      virtual void onAntiTheftUnlockHUStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHUStatus >& status);

      virtual void onKdsEntryError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< KdsEntryError >& error);

      virtual void onKdsEntryStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< KdsEntryStatus >& status);

      virtual void onAntiTheftStatusError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftStatusError >& error);
      virtual void onAntiTheftStatusStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftStatusStatus >& status);
      long int u32GetVINValue();

#endif

   public:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MASTER_HALL)
      COURIER_MSG_MAP_END()

   private:
      ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy > _diagnosticProxy;
      uint32 m_vid_value;
      static diagnosisClientHandler* _diagnosisClientHandler;
#ifdef VARIANT_S_FTR_ENABLE_ANTI_THEFT
      bool bReadData(uint16 u16KdsKey, uint16 u16DataLen, uint8* pu8DataBuffer);
      bool performASCIIHexToStringConversion(uint8 asciiValue[], uint8 byteSize , std::string& kdsData);
      long int longint_VehicleId;
#endif
      ::App::datamodel::DataModel* _dataModelInstance;
      uint8 getKDSUpdateStatus();
};


} // namespace Core
} // namespace App
#endif //DIAGNOSISCLIENTHANDLER_HEADER
