/**
 * @file         : ContextSwitchHandlerConstants.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ContextSwitchHandlerConstants is to handle the ContextSwitchHandler
 *                 feature constants implementation.
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CONTEXT_SWITCH_HANDLER_CONSTANTS_H
#define CONTEXT_SWITCH_HANDLER_CONSTANTS_H


#include <map>
#include <vector>
#include <string>
#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class RequestBase;
class ApplicationContextInfo;
class ContextSwitchRequestInfo;
class IActiveContextListenerCB;
} //namespace Core
} //namespace App


/**
 *  Enums Declaration
 */

namespace App {
namespace Core {


/**
 * enContextSwitchState is used to
 *  - Hold context switch state information
 */
enum enContextSwitchState
{
   CONTEXT_SWITCH_STATE_IDLE
   , CONTEXT_SWITCH_STATE_PROCESS
};


} //namespace Core
} //namespace App


/**
 *  Typedefs Declaration
 */

namespace App {
namespace Core {


//Typedef for switch stack info (-> INFO: Based on application)
typedef ::std::vector< uint32 > SwitchStackInfo;

//Typedef for queued requests array
typedef ::std::vector< RequestBase* > QueuedRequestsInfo;

//Typedef for ApplicationContextInfo array
typedef ::std::vector< ApplicationContextInfo > ApplicationsContextInfo;

//Typedef for application context listeners array
typedef ::std::vector< IActiveContextListenerCB* > ActiveContextListenersInfo;
} //namespace Core
} //namespace App


#endif /* CONTEXT_SWITCH_HANDLER_CONSTANTS_H */
