/**
 * @file         : ContextsPriorityInfoConfigDefines.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ContextsPriorityInfoConfigDefines is to handle ContextsPriorityInfo
 *                 configuration defines implementation.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CONTEXTS_PRIORITY_INFO_CONFIG_DEFINES_H
#define CONTEXTS_PRIORITY_INFO_CONFIG_DEFINES_H


/**
 *  Defines Declaration
 *  Note: These defines are not having undef
 */

//Define to begin ContextsPriorityInfo configuration
#define BEGIN_CONTEXTS_PRIORITY_INFO_CONFIG()                                                       \
      ContextsPriorityInfo tContextsPriorityInfo;                                                   \
      {
//Define to add ContextsPriorityInfo
//INFO:
// -> Param1 : Context id
// -> Param2 : Priority
// -> Param3 : Conditions to evaluate before adding the info
#define ADD_CONTEXT_PRIORITY_INFO(_contextId_, _priority_, _cond_)                                  \
         {                                                                                          \
            bool isValid = (_cond_) ? true : false;                                                 \
            if(isValid)                                                                             \
            {                                                                                       \
               tContextsPriorityInfo.insert(::std::make_pair(_contextId_, _priority_));             \
            }                                                                                       \
         }

//Define to end ContextsPriorityInfo configuration
#define END_CONTEXTS_PRIORITY_INFO_CONFIG()                                                         \
      }                                                                                             \
      return tContextsPriorityInfo;


#endif /* CONTEXTS_PRIORITY_INFO_CONFIG_DEFINES_H */
