/**
 * @file         : ContextPriorityHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ContextPriorityHandlerInterface is to handle the ContextPriorityHandler
 *                 feature interface implementation.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CONTEXT_PRIORITY_HANDLER_INTERFACE_H
#define CONTEXT_PRIORITY_HANDLER_INTERFACE_H


#include <asf/core/Types.h>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


/**
 * IContextPriorityHandler is used to
 *  - Provide interface impl between Users and ContextPriorityHandler.
 */
class IContextPriorityHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      IContextPriorityHandler() {}
      virtual ~IContextPriorityHandler() {}
      virtual uint8 getContextPriority(const uint32 contextId) const = 0;
};


} //namespace Core
} //namespace App


#endif /* CONTEXT_PRIORITY_HANDLER_INTERFACE_H */
