/**
 * @file         : ContextPriorityHandler.cpp
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ContextPriorityHandler is to handle the context priority information.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#include "ContextPriorityHandler.h"
#include "ApplicationSwitchConst.h"


using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;


namespace App {
namespace Core {


ContextPriorityHandler::ContextPriorityHandler()
{
   clear();
   initContextsPriorityInfo();
}


ContextPriorityHandler::~ContextPriorityHandler()
{
   clear();
}


ContextPriorityHandler::ContextPriorityHandler(const ContextPriorityHandler& obj)
{
   clear();
   *this = obj;
}


ContextPriorityHandler& ContextPriorityHandler::operator= (const ContextPriorityHandler& obj)
{
   if (this != (&obj))
   {
      clear();
      _contextsPriorityInfo = obj._contextsPriorityInfo;
   }
   return (*this);
}


uint8 ContextPriorityHandler::getContextPriority(const uint32 contextId) const
{
   uint8 tPriority = 0xFF;
   ContextsPriorityInfo::const_iterator itr = _contextsPriorityInfo.find(contextId);
   if (itr != _contextsPriorityInfo.end())
   {
      tPriority = itr->second;
   }
   return tPriority;
}


ContextPriorityHandler::ContextsPriorityInfo ContextPriorityHandler::getContextsPriorityInfo() const
{
#define CONFIGURE_CONTEXTS_PRIORITY_INFO
#include "ContextsPriorityInfo.dat"
#undef CONFIGURE_CONTEXTS_PRIORITY_INFO
}


} //namespace Core
} //namespace App
