/**
 * @file         : MonoGlassControllerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : MonoGlassControllerInterface is to handle the CabinConnectionController
 *                 feature interfaces implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef MONOGLASSCONTROLLER_INTERFACE_H
#define MONOGLASSCONTROLLER_INTERFACE_H

#include "CabinConnectionControllerInterface.h"


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class IMonoGlassController: public ICabinConnectionController
{
   public:
      /**
       *  Member Function Declaration
       */
      IMonoGlassController() {}
      virtual ~IMonoGlassController() {}
      virtual bool fetchAVRestoreInfo(const int16 sinkId, HB_AUDIO::stSourceInfo& info) = 0;
      virtual void updateMonoModeStatus(const uint32 regionId, const bool status) = 0;
};


} //namespace Core
} //namespace App


#endif /* CABINCONNECTIONCONTROLLER_INTERFACE_H */
