/****************************************************************************
* Copyright (c) 2021-2022 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CabinsActivityInfoDpHandler.hpp
* COMPONENT Name      : AppHmi_Master
* DESCRIPTION         : Handles datapool implementation for CabinActivityInfo.
* AUTHOR              : Dubba Venkata Sairam
* Date                : 01.09.2021
* Revision History    : 0.1
* Date 11.02.2019     : Initial version
****************************************************************************/

#ifndef CABIN_ACTIVITY_DP_HANDLER_H
#define CABIN_ACTIVITY_DP_HANDLER_H


#include <list>
#include "CabinsActivityInfoDpHandlerInterface.h"
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_01_if.h"
#include "dp_generic_if.h"
#endif


namespace App {
namespace Core {


class CabinsActivityInfoDpHandler : public ICabinsActivityInfoDpHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      CabinsActivityInfoDpHandler();
      virtual ~CabinsActivityInfoDpHandler();
      CabinActivitiesInfo getCabinActivitiesInfo(const uint32 cabinId);
      void clear();
      void prepareDPUpdate(ICabinActivityInfoUpdater& imp);
      void finalizeDPUpdate(ICabinActivityInfoUpdater& imp);
      void updateDPData(ICabinActivityInfoUpdater& imp, const CabinActivityInfoDPHolder& newCabinsActivityInfo);

   private:
      /**
       *  Member Functions Declaration
       */
      CabinsActivityInfoDpHandler(const CabinsActivityInfoDpHandler& obj);
      CabinsActivityInfoDpHandler& operator= (const CabinsActivityInfoDpHandler& obj);
      bool isContentChanged();
      void dumpInfoToDP();
      void dumpInfoFromDP();
      /**
       *  Member Variables Declaration
       */
      CabinsActivitiesInfo _tempInfo;
      CabinsActivitiesInfo _dupDpInfo;
      ICabinActivityInfoUpdater* _updater;
      dp_tclAppHmi_MasterCabinsActivityInfoDP _dpInfo;
};


} //namespace Core
} //namespace App


#endif /* CABIN_ACTIVITY_DP_HANDLER_H */
