/****************************************************************************
* Copyright (c) 2021-2022 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CabinVideoMixInfoDpHandler.h
* COMPONENT Name      : AppHmi_Master
* DESCRIPTION         : Handles datapool implementation for CabinVideoMixInfo.
* AUTHOR              : pgi5cob
* Date                : 10.03.2022
* Revision History    : 0.1
* Date 10.03.2022     : Initial version
****************************************************************************/

#ifndef CABIN_VIDEO_MIX_INFO_DP_HANDLER_H
#define CABIN_VIDEO_MIX_INFO_DP_HANDLER_H


#include <list>
#include "CabinVideoMixInfoDpHandlerInterface.h"
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_01_if.h"
#include "dp_generic_if.h"
#endif


namespace App {
namespace Core {


class CabinVideoMixInfoDpHandler : public ICabinVideoMixInfoDpHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      CabinVideoMixInfoDpHandler();
      virtual ~CabinVideoMixInfoDpHandler();
      const CabinsVideoMixInfoHolder& getCabinsVideoMixInfo() const;
      const enCabinVideoMixIndex getVideoMixIndexForCabin(const uint32 cabinId) const;
      const CabinVideoMixInfoHolder* getVideoMixInfoForCabin(const uint32 cabinId) const;
      void updateCabinVideoMixDPData(const CabinVideoMixInfoHolder& newCabinVideoMixInfo);

   private:
      /**
       *  Member Functions Declaration
       */
      CabinVideoMixInfoDpHandler(const CabinVideoMixInfoDpHandler& obj);
      CabinVideoMixInfoDpHandler& operator= (const CabinVideoMixInfoDpHandler& obj);
      bool isContentChanged();
      void dumpInfoToDP();
      void dumpInfoFromDP();
      /**
       *  Member Variables Declaration
       */
      CabinsVideoMixInfoHolder _dupDpInfo;
      dp_tclAppHmi_MasterCabinVideoMixDP _dpInfo;
};


} //namespace Core
} //namespace App


#endif /* CABIN_ACTIVITY_DP_HANDLER_H */
