/****************************************************************************
* Copyright (c) 2021-2022 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CabinVideoMixInfoDpHandler.cpp
* COMPONENT Name      : AppHmi_Master
* DESCRIPTION         : Handles datapool implementation for CabinVideoMixInfo.
* AUTHOR              : pgi5cob
* Date                : 10.03.2022
* Revision History    : 0.1
* Date 10.03.2022     : Initial version
****************************************************************************/

#include "CabinVideoMixInfoDpHandler.h"
#include "hmi_trace_if.h"
#include <datapool/CabinVideoMixInfoDPIF.h>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_MASTER_MAIN
#include "trcGenProj/Header/CabinVideoMixInfoDpHandler.cpp.trc.h"
#endif


namespace App {
namespace Core {


CabinVideoMixInfoDpHandler::CabinVideoMixInfoDpHandler()
{
   ETG_TRACE_USR1(("CabinVideoMixInfoDpHandler"));
   dumpInfoFromDP();
}


CabinVideoMixInfoDpHandler::~CabinVideoMixInfoDpHandler()
{
   ETG_TRACE_USR1(("~CabinVideoMixInfoDpHandler"));
}


void CabinVideoMixInfoDpHandler::updateCabinVideoMixDPData(const CabinVideoMixInfoHolder& newCabinVideoMixInfo)
{
   ETG_TRACE_USR1(("CabinVideoMixInfoDpHandler::updateCabinVideoMixDPData"));
   bool isUpdated = false;
   CabinsVideoMixInfoHolder::iterator itr = _dupDpInfo.begin();
   for (; (itr != _dupDpInfo.end()); ++itr)
   {
      if ((*itr).getCabinId() == newCabinVideoMixInfo.getCabinId())
      {
         ETG_TRACE_USR1(("CabinVideoMixInfoDpHandler::updateCabinVideoMixDPData: Existed cabin: %d", (*itr).getCabinId()));
         if ((*itr).getVideoMixIndex() != newCabinVideoMixInfo.getVideoMixIndex())
         {
            (*itr).setVideoMixIndex(newCabinVideoMixInfo.getVideoMixIndex());
            isUpdated = true;
         }
         break;
      }
   }
   if (itr == _dupDpInfo.end())
   {
      ETG_TRACE_USR1(("CabinVideoMixInfoDpHandler::updateCabinVideoMixDPData: cabin: %d", newCabinVideoMixInfo.getCabinId()));
      _dupDpInfo.push_back(newCabinVideoMixInfo);
      isUpdated = true;
   }
   if (isUpdated)
   {
      dumpInfoToDP();
   }
}


void CabinVideoMixInfoDpHandler::dumpInfoToDP()
{
   if (!_dupDpInfo.empty())
   {
      _dpInfo.vClearList();
      for (CabinsVideoMixInfoHolder::iterator itr = _dupDpInfo.begin(); (itr != _dupDpInfo.end()); ++itr)
      {
         ETG_TRACE_USR1(("CabinVideoMixInfoDpHandler::dumpInfoToDP: CabinId: %d, VideoMixIndex: %d", (*itr).getCabinId(), (*itr).getVideoMixIndex()));
         _dpInfo.vPushBack(*itr);
      }
   }
}


void CabinVideoMixInfoDpHandler::dumpInfoFromDP()
{
   _dupDpInfo.clear();
   for (uint32 index = 0; (index < _dpInfo.u32GetCount()); ++index)
   {
      CabinVideoMixInfoHolder cabinvideoMixInfo;
      if (_dpInfo.s32GetElem(index, cabinvideoMixInfo) != DP_S32_ERR_NO_ELEMENT)
      {
         ETG_TRACE_USR1(("CabinVideoMixInfoDpHandler::dumpInfoFromDP: CabinId: %d, VideoMixIndex: %d", cabinvideoMixInfo.getCabinId(), cabinvideoMixInfo.getVideoMixIndex()));
         _dupDpInfo.push_back(cabinvideoMixInfo);
      }
   }
}


const enCabinVideoMixIndex CabinVideoMixInfoDpHandler::getVideoMixIndexForCabin(const uint32 cabinId) const
{
   enCabinVideoMixIndex videoMixIndex = CABIN_VIDEO_MIX_INDEX_NONE;
   for (CabinsVideoMixInfoHolder::const_iterator dupInfoItr = _dupDpInfo.begin(); (dupInfoItr != _dupDpInfo.end()); ++dupInfoItr)
   {
      if (cabinId == (*dupInfoItr).getCabinId())
      {
         videoMixIndex = static_cast<enCabinVideoMixIndex>((*dupInfoItr).getVideoMixIndex());
         break;
      }
   }
   return videoMixIndex;
}


const CabinsVideoMixInfoHolder& CabinVideoMixInfoDpHandler::getCabinsVideoMixInfo() const
{
   return _dupDpInfo;
}


const CabinVideoMixInfoHolder* CabinVideoMixInfoDpHandler::getVideoMixInfoForCabin(const uint32 cabinId) const
{
   const CabinVideoMixInfoHolder* imp = NULL;
   for (CabinsVideoMixInfoHolder::const_iterator dupInfoItr = _dupDpInfo.begin(); (dupInfoItr != _dupDpInfo.end()); ++dupInfoItr)
   {
      if (cabinId == (*dupInfoItr).getCabinId())
      {
         imp = &(*dupInfoItr);
         break;
      }
   }
   return imp;
}


} //namespace Core
} //namespace App
