/**
 * @file         : CabinConnectionHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinConnectionHandlerInterface is to handle the CabinConnectionHandler
 *                 feature interfaces implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABINCONNECTIONHANDLER_INTERFACE_H
#define CABINCONNECTIONHANDLER_INTERFACE_H


#include <map>
#include <asf/core/Types.h>
#include <boost/shared_ptr.hpp>
#include "CabinConnectionHandlerConstants.h"
#include "CabinRestorationHandlerConstants.h"
#include <Core/RegionHandling/RegionHandlingConstants.h>
#include <Core/HmiInfoService/HmiInfoServiceServerComponentHandlingInterface.h>

/**
 *  Classes Forward Declaration
 */

class SoundControllerPrj;
class IResourceControllerPrj;
class ConnectionControllerPrj;
class IHmiInfoServiceServerComponent;

namespace App {
namespace Core {


class IRegionHandling;
class IHmiStateHandler;
class IMIC1ConnectionStatus;
class CabinConnectionUtility;
class IMapOutStatusListenerCB;
class IMixSrcConnectionStatus;
class ICabinRestorationHandler;
class ICabinVideoMixInfoDpHandler;
class ICabinsActivityInfoDpHandler;
class IApplicationSwitchServerComponent;
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
class INanoMsgClientHandler;
#endif /* VARIANT_S_FTR_ENABLE_MIC_ACTIVATION */
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ICabinConnectionHandler: public ICabinVideoMixInfoImpl
{
   public:
      /**
       *  Member Function Declaration
       */
      ICabinConnectionHandler() {}
      virtual ~ICabinConnectionHandler() {}
      virtual bool onSourceRequest(const int16 srcId, const int16 devId, const int16 sinkId) = 0;
      virtual void finalize() = 0;
      virtual void initialize() = 0;
      virtual void setRegionHandling(IRegionHandling& imp) = 0;
      virtual void setHMIStateHandler(IHmiStateHandler& imp) = 0;
      virtual void setCabinConnectionUtility(CabinConnectionUtility& imp) = 0;
      virtual void setCabinRestorationHandler(ICabinRestorationHandler& imp) = 0;
      virtual void setCabinVideoMixInfoDpHandler(ICabinVideoMixInfoDpHandler& imp) = 0;
      virtual void onCabinsActivityRestorationInfo(const RestoreRegionsInfo& info) = 0;
      virtual void setCabinsActivityInfoDpHandler(ICabinsActivityInfoDpHandler& imp) = 0;
      virtual void setHmiInfoServiceServerComponent(IHmiInfoServiceServerComponent& imp) = 0;
      virtual void onSourceDisconnect(const int16 srcId, const int16 devId, const int16 sinkId) = 0;
      virtual void setResourceController(const ::boost::shared_ptr< IResourceControllerPrj >& imp) = 0;
      virtual void updateCabinConnections(const SinkConnectionMap& newSinkInfos, const SinkConnectionMap& suspendedSinkInfos) = 0;
      virtual void updateCabinConnectionsForMixSource(const SinkConnectionMap& newSinkInfos, const SinkConnectionMap& suspendedSinkInfos) = 0;
      virtual void onSetCabinVideoMixInfo(const uint32 regionId, const uint8 videoMixIndex, const uint8 reason = CABIN_VIDEO_MIX_CHANGE_REASON_USER) = 0;
#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
      virtual uint8 getCabinMapOutStatus(const uint32 regionId) const = 0;
      virtual const RegionMapOutInfo* getRegionMapOutInfo(const uint32 regionId) const = 0;
      virtual void onToggleMapOutStatus(const uint32 regionId) = 0;
      virtual void addMapOutStateListener(IMapOutStatusListenerCB& imp) = 0;
      virtual void removeMapOutStateListener(IMapOutStatusListenerCB& imp) = 0;
      virtual void onMapOutStatusUpdMsg(const uint32 regionId, const bool bActivationStatus) = 0;
#endif /* VARIANT_S_FTR_ENABLE_MAP_STREAMING */
#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
      virtual bool getMic1Status() = 0;
      virtual void onUpdateMic1Status(const bool status) = 0;
      virtual void setNanoMsgClientHandler(INanoMsgClientHandler& imp) = 0;
      virtual void addMic1StatusListener(IMIC1ConnectionStatus* pObserver) = 0;
      virtual void removeMic1StatusListener(IMIC1ConnectionStatus* pObserver) = 0;
      virtual void addMixSrcStatusListener(IMixSrcConnectionStatus* pObserver) = 0;
      virtual void removeMixSourceStatusListener(IMixSrcConnectionStatus* pObserver) = 0;
#endif /* VARIANT_S_FTR_ENABLE_MIC_ACTIVATION */
};


class IMixSrcConnectionStatus
{
   public:
      IMixSrcConnectionStatus() {};
      virtual  ~IMixSrcConnectionStatus() {}
      virtual void currentMixSourceConnectionStatus(const int16 sourceId, const bool status, const int16 sinkid, int mixSourceIndex) = 0;
};


#ifdef VARIANT_S_FTR_ENABLE_MIC_ACTIVATION
class IMIC1ConnectionStatus
{
   public:
      IMIC1ConnectionStatus() {};
      virtual  ~IMIC1ConnectionStatus() {}
      virtual void currentMIC1ConnectionStatus(const bool status) = 0;
};


#endif /* VARIANT_S_FTR_ENABLE_MIC_ACTIVATION */


#ifdef VARIANT_S_FTR_ENABLE_MAP_STREAMING
class IMapOutStatusListenerCB
{
   public:
      IMapOutStatusListenerCB() {};
      virtual ~IMapOutStatusListenerCB() {}
      virtual void onMapOutStatusUpdate(const uint32 regionId, const SinksMapOutInfo& info) = 0;
};


#endif /* VARIANT_S_FTR_ENABLE_MAP_STREAMING */
} //namespace Core
} //namespace App


#endif /* CABINCONNECTIONHANDLER_INTERFACE_H */
