/**
 * @file         : CabinConnectionHandlerDefines.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : CabinConnectionHandlerDefines contains defines used in CabinConnectionHandler
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef CABINCONNECTIONHANDLER_DEFINES_H
#define CABINCONNECTIONHANDLER_DEFINES_H

#define HB_AUDIO        ::hmibase::apphmi_master::audio
#define AUDIOCONTROL_AVB_STREAM    0
#define AUDIOCONTROL_RTP_STREAM    1
#define PRESENTATIONTIME_DEFAULT   0
#define DEFAULT_BEEPOUTPUTVALUE    7
#define CABIN_MIN_SYSTEM_GROUP     1
#define MAX_CONNECTION_REQUESTS    10
#define STATE_DISCONNECT           (STATE_SUSPENDED + 1)  //mapout status - restore
#define STATE_RESTORE              (STATE_DISCONNECT + 1)  //mapout status - restore


#endif//CABINCONNECTIONHANDLER_DEFINES_H
