/**************************************************************************************
* @file         : BTCLIENTHANDLER.cpp
* @author       : ECG - vta5kor
* @addtogroup   : AppHmi_master
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "BTClientHandler.h"


#define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
#include "utf_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS         TR_CLASS_APPHMI_MASTER_HALL
#define ETG_I_TRACE_CHANNEL             TR_TTFIS_APPHMI_MASTER
#define ETG_I_TTFIS_CMD_PREFIX          "APPHMI_Master_"
#define ETG_I_FILE_PREFIX               App::Core::BTClientHandler::

#include "trcGenProj/Header/BTClientHandler.cpp.trc.h"
#endif

using namespace ::App::Core;

namespace App {
namespace Core {

BTClientHandler* BTClientHandler::_btClientHandler = NULL;

/**
 * @Destructor
 */
BTClientHandler::~BTClientHandler()
{
   ETG_TRACE_USR4(("BTClientHandler::BTClientHandler destructor"));
   _btClientHandler = NULL;
   _btSettingProxy.reset();
   ETG_I_UNREGISTER_FILE();
}


/**
* @Constructor
*/
BTClientHandler::BTClientHandler()
   : _btSettingProxy(::MOST_BTSet_FI::MOST_BTSet_FIProxy::createProxy("masterBTSetFiPort", *this))

{
   StartupSync::getInstance().registerPropertyRegistrationIF(this, _btSettingProxy->getPortName());
   _btClientHandler = this;
   ETG_I_REGISTER_FILE();
   m_bBluetoothAvailability = true;
}


/*****************************************************************************
* onAvailable: Register for properties once service is available
*****************************************************************************/
void BTClientHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR2(("ServiceBT onAvailable(_btSetProxy)"));
   if (_btSettingProxy && _btSettingProxy == proxy)
   {
      ETG_TRACE_USR4(("registerProperties from btsetting"));
      _btSettingProxy->sendBluetoothOnOffUpReg(*this);
   }
}


/*****************************************************************************
* onUnavailable: De-register for properties once service is unavailable
*****************************************************************************/
void BTClientHandler::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("ServiceBT onUnavailable(_btSetProxy)"));
   if (_btSettingProxy && _btSettingProxy == proxy)
   {
      _btSettingProxy->sendBluetoothOnOffRelUpRegAll();
   }
}


/**
 * deregisterProperties - Trigger property deregistration to BT properties,
 * @param[in] proxy
 * @parm[in] stateChange - state change service for corrosponding  proxy
 * @return void
 */
void BTClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   /*if (_btSettingProxy && _btSettingProxy == proxy)
   {
      _btSettingProxy->sendBluetoothOnOffRelUpRegAll();
   }*/
}


/**
 * registerProperties - Trigger property registration to BT properties,
 * @param[in] proxy
 * @parm[in] stateChange - state change service for corrosponding  proxy
 * @return void
 */
void BTClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   /* if (_btSettingProxy && _btSettingProxy == proxy)
    {
       ETG_TRACE_USR4(("registerProperties from btsetting"));
     _btSettingProxy->sendBluetoothOnOffUpReg(*this);
    }*/
}


/**
 * onBluetoothOnOffError - called if BT On Off property is updated with error from BT
 *
 * @param[in] proxy
 * @parm[in] error
 * @return void
 */
void BTClientHandler::onBluetoothOnOffError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy>&, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffError >&)
{
   ETG_TRACE_USR4(("BTSetting::onBluetoothOnOffError"));
}


/**
 * onBluetoothOnOffStatus - received status update for Bluetooth Availability
 *
 * @param[in] proxy
 * @parm[in] status
 * @return void
 */
void BTClientHandler::onBluetoothOnOffStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy>& proxy, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffStatus >& status)
{
   ETG_TRACE_USR4(("onBluetoothOnOffStatus "));
   m_bBluetoothAvailability = status->getBBTOnOff();
   ETG_TRACE_USR4(("m_bBluetoothAvailability : %d", m_bBluetoothAvailability));
}


bool BTClientHandler::getBTStatus()
{
   ETG_TRACE_USR4(("m_bBluetoothAvailability : %d", m_bBluetoothAvailability));
   return m_bBluetoothAvailability;
}


}//App
}//Core
