/**
 * @file         : SoundControllerPrj.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : SoundControllerPrj is project extension of HMIBase SoundController
 * @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */

#ifndef CLSOUNDCONTROLLERPRJ_H
#define CLSOUNDCONTROLLERPRJ_H


#include "SoundControllerPrjInterface.h"
#include "AppHmi_MasterBase/AudioInterface/SoundController.h"
#include <Core/AudioInterface/ResourceControllerPrjInterface.h>


class SoundControllerPrj : public hmibase::apphmi_master::audio::SoundController
   , public ISoundControllerPrj
   , public IUpdateSinkListenerCB
{
   public:
      /**
       *  Member Functions Declaration
       */
      SoundControllerPrj();
      virtual ~SoundControllerPrj();
      bool onVolumeValueChange(int sinkId, int volume);
      void onSinkMuteStateChange(int nSinkId, int nMuteState);
      void onSoundPropertyListUpdate(int nSinkId);
      void updateSetSystemMuteReq(bool muteStatus, uint32 regionId);
      void onUpdateSinkChange(const uint32 sinkIndex);
      bool getSystemMuteStatusForRegionId(const uint32 regionId) const;

      inline void addMuteStateListener(IMuteStateListenerCB& imp)
      {
         ::std::vector< IMuteStateListenerCB* >::const_iterator itr = ::std::find(_muteStateListeners.begin(), _muteStateListeners.end(), (&imp));
         if (itr == _muteStateListeners.end())
         {
            _muteStateListeners.push_back((&imp));
         }
      }

      inline void removeMuteStateListener(IMuteStateListenerCB& imp)
      {
         ::std::vector< IMuteStateListenerCB* >::iterator itr = ::std::find(_muteStateListeners.begin(), _muteStateListeners.end(), (&imp));
         if (itr != _muteStateListeners.end())
         {
            (void)_muteStateListeners.erase(itr);
         }
      }

      inline void addVolumeChangeListener(IVolumeChangeListenerCB& imp)
      {
         ::std::vector< IVolumeChangeListenerCB* >::const_iterator itr = ::std::find(_volumeChangeListeners.begin(), _volumeChangeListeners.end(), (&imp));
         if (itr == _volumeChangeListeners.end())
         {
            _volumeChangeListeners.push_back((&imp));
         }
      }

      inline void removeVolumeChangeListener(IVolumeChangeListenerCB& imp)
      {
         ::std::vector< IVolumeChangeListenerCB* >::iterator itr = ::std::find(_volumeChangeListeners.begin(), _volumeChangeListeners.end(), (&imp));
         if (itr != _volumeChangeListeners.end())
         {
            (void)_volumeChangeListeners.erase(itr);
         }
      }

      inline void addSoundPropertyListener(ISoundPropertyListenerCB& imp)
      {
         ::std::vector< ISoundPropertyListenerCB* >::const_iterator itr = ::std::find(_soundPropertyListeners.begin(), _soundPropertyListeners.end(), (&imp));
         if (itr == _soundPropertyListeners.end())
         {
            _soundPropertyListeners.push_back((&imp));
         }
      }

      inline void removeSoundPropertyListener(ISoundPropertyListenerCB& imp)
      {
         ::std::vector< ISoundPropertyListenerCB* >::iterator itr = ::std::find(_soundPropertyListeners.begin(), _soundPropertyListeners.end(), (&imp));
         if (itr != _soundPropertyListeners.end())
         {
            (void)_soundPropertyListeners.erase(itr);
         }
      }
      inline void initialize()
      {
         if (NULL != _resourceController.get())
         {
            _resourceController->addSinkUpdateListener((*this));
         }
      }

      inline void finalize()
      {
         if (NULL != _resourceController.get())
         {
            _resourceController->removeSinkUpdateListener((*this));
         }
      }

      inline void setResourceController(const ::boost::shared_ptr< IResourceControllerPrj >& imp)
      {
         _resourceController = imp;
      }

   private:
      /**
       *  Member Functions Declaration
       */
      SoundControllerPrj(const SoundControllerPrj& obj);
      SoundControllerPrj& operator= (const SoundControllerPrj& obj);
      /**
       *  Member Variables Declaration
       */
      ::std::vector< IMuteStateListenerCB* > _muteStateListeners;
      ::std::vector< IVolumeChangeListenerCB* > _volumeChangeListeners;
      ::std::vector< ISoundPropertyListenerCB* > _soundPropertyListeners;
      ::boost::shared_ptr< IResourceControllerPrj > _resourceController;
      ::std::map< uint32, bool > _systemMuteStatusInfo;
};


#endif /* CLSOUNDCONTROLLERPRJ_H */
