/**
 * @file         : ResourceControllerPrj.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ResourceControllerPrj is project extension of HMIBase ResourceController
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef RESOURCECONTROLLERPRJ_H
#define RESOURCECONTROLLERPRJ_H


#include "ResourceControllerPrjInterface.h"
#include <AppHmi_MasterBase/AudioInterface/ResourceController.h>


class ResourceControllerPrj : public hmibase::apphmi_master::audio::ResourceController
   , public IResourceControllerPrj
{
   public:
      /**
       *  Member Functions Declaration
       */
      ResourceControllerPrj();
      virtual ~ResourceControllerPrj();
      int32 getSourceAvailability(const int32 srcIndex);
      int32 getSourceAvailability(const int32 srcIndex, const int32 deviceId);
      bool isSinkAdded(const int sinkIndex);
      bool isMainSource(const uint32 sourceId);
      bool isAnnouncementSource(const uint32 sourceId);
      void UpdateSourceListChange(int32 nSrcIndex);
      void OnUpdateSink(int nSinkIndex);

      inline bool isSourceAvailable(const int32 srcIndex)
      {
         bool isValid = (getSourceAvailability(srcIndex) == RES_AVAILABLE) ? true : false;
         return isValid;
      }

      inline bool isSourceAvailable(const int32 srcIndex, const int32 deviceId)
      {
         bool isValid = (getSourceAvailability(srcIndex, deviceId) == RES_AVAILABLE) ? true : false;
         return isValid;
      }

      inline void addSourceListUpdateListener(IUpdateSourceListListenerCB& imp)
      {
         ::std::vector< IUpdateSourceListListenerCB* >::const_iterator itr = ::std::find(_sourceListUpdateListeners.begin(), _sourceListUpdateListeners.end(), (&imp));
         if (itr == _sourceListUpdateListeners.end())
         {
            _sourceListUpdateListeners.push_back((&imp));
         }
      }

      inline void removeSourceListUpdateListener(IUpdateSourceListListenerCB& imp)
      {
         ::std::vector< IUpdateSourceListListenerCB* >::iterator itr = ::std::find(_sourceListUpdateListeners.begin(), _sourceListUpdateListeners.end(), (&imp));
         if (itr != _sourceListUpdateListeners.end())
         {
            (void)_sourceListUpdateListeners.erase(itr);
         }
      }

      inline void addSinkUpdateListener(IUpdateSinkListenerCB& imp)
      {
         ::std::vector< IUpdateSinkListenerCB* >::const_iterator itr = ::std::find(_sinkUpdateListeners.begin(), _sinkUpdateListeners.end(), (&imp));
         if (itr == _sinkUpdateListeners.end())
         {
            _sinkUpdateListeners.push_back((&imp));
         }
      }

      inline void removeSinkUpdateListener(IUpdateSinkListenerCB& imp)
      {
         ::std::vector< IUpdateSinkListenerCB* >::iterator itr = ::std::find(_sinkUpdateListeners.begin(), _sinkUpdateListeners.end(), (&imp));
         if (itr != _sinkUpdateListeners.end())
         {
            (void)_sinkUpdateListeners.erase(itr);
         }
      }

   private:
      /**
       *  Member Variables Declaration
       */
      ::std::vector< IUpdateSourceListListenerCB* > _sourceListUpdateListeners;
      ::std::vector< IUpdateSinkListenerCB*> _sinkUpdateListeners;
};


#endif // RESOURCECONTROLLERPRJ_H
