/**
 * @file         : ConnectionControllerPrj.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ConnectionControllerPrj is to handle the audio connections
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */

#ifndef CONNECTIONCONTROLLER_PRJ_H
#define CONNECTIONCONTROLLER_PRJ_H


#include "ProjectBaseTypes.h"
#include "ConnectionControllerPrjInterface.h"


#define NS_MASTER_AUDIO ::hmibase::apphmi_master::audio


/**
 *  Classes Declaration
 */

class ConnectionControllerPrj : public IConnectionControllerPrj
   , public hmibase::apphmi_master::audio::ConnectionController
{
   public:
      /**
       *  Member Functions Declaration
       */
      ConnectionControllerPrj();
      virtual ~ConnectionControllerPrj() {};
      int16 getPrivateSpeakerSinkId();
      int16 getCurrentActiveSource(const int16 sinkId);
      int16 getActiveSourceIdOnSink(const int16 sinkId);
      int16 getCurrentActiveAnnouncementSource(const int16 sinkId);
      bool fetchCurrentActiveSource(const int16 sinkId, int& srcIndex, int& srcDeviceId);
      void sendApplicationStart(enApplicationId nAppId);
      void setVisibleApplication(enApplicationId nAppId);
      void vRegisterforConnectionInfoUpdate(IConnectionInfoUpdate* client);
      void vUnRegisterforConnectionInfoUpdate(IConnectionInfoUpdate* client);
      virtual bool groupRequest(int nGrpIndex);
      virtual void onNewActiveConnections();
      virtual void sendConnectionInfoUpdate();
      virtual void sendLastApplicationRequest();
      virtual void actionOnNoSrc(int nGrpIndex);
      virtual void sendSourceActivationMsgRequest(int nSrcIndex);
      virtual void evalApplicationStart(int grpIndex, hmibase::apphmi_master::audio::Source* src);
      virtual bool sourceRequest(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      virtual void sourceDisconnect(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);

      inline enApplicationId getVisibleApplication()
      {
         return m_ActiveAppId;
      }
      inline bool isPrivateSpeakerConnected() const
      {
         bool isValid = (m_PrivateSpeakerSinkId == PRIVATE_SPEAKER_SINK_ID) ? true : false;
         return isValid;
      }

#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
      bool sendCabinSourceRequest(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      void sendCabinSourceDisconnect(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);

      inline void setCabinConnectionHandler(::App::Core::ICabinConnectionHandler& imp)
      {
         _cabinConnectionHandler = (&imp);
      }
#endif

   protected:
      /**
       *  Member Functions Declaration
       */
      void ReadPersistentApplication();
      void WritePersistentApplication();

   private:
      /**
       *  Member Functions Declaration
       */
      void updateActiveSrcOnSinkId();
      /**
       *  Member Variables Declaration
       */
      int16 m_PrivateSpeakerSinkId;
      enApplicationId m_ActiveAppId;
      std::vector< IConnectionInfoUpdate* > _connectionInfoUpdateCB;
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
      ::App::Core::ICabinConnectionHandler* _cabinConnectionHandler;
#endif
};


#undef NS_MASTER_AUDIO

#endif
