/**
 * @file         : ApplicationSwitchServerComponentInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ApplicationSwitchServerComponentInterface is to handle the ApplicationSwitchServerComponent
 *                 feature interface implementation
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef APPLICATION_SWITCH_SERVER_COMPONENT_INTERFACE_H
#define APPLICATION_SWITCH_SERVER_COMPONENT_INTERFACE_H


#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class IRegionHandling;
class IContextSwitchHandler;
class AppFlyIn;
} //namespace Core
} //namespace App


class HmiInfoServiceServerComponent;


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class IApplicationSwitchServerComponent
{
   public:
      /**
       *  Member Functions Declaration
       */
      IApplicationSwitchServerComponent() {}
      virtual ~IApplicationSwitchServerComponent() {}
      virtual void setRegionHandling(IRegionHandling& imp) = 0;
      virtual void setContextSwitchHandler(IContextSwitchHandler& imp) = 0;
      virtual void setHmiInfoServiceServerComponent(HmiInfoServiceServerComponent& imp) = 0;
      virtual void setAppFlyIn(AppFlyIn& imp) = 0;
      virtual void sendSWCKeyEventSignal(const uint32 event) = 0;
      virtual void sendControlPanelButtonPressUpdateSignal(const uint8 notchButton, const uint8 buttonState, const uint32 receiverAppID) = 0;
      virtual void sendSpeechSessionSignal(const bool status) = 0;
      virtual void sendSPIVoiceRecognitionSignal(const uint32 event) = 0;
      virtual void sendRegionChangePropertyUpdate(const uint32 regionId) = 0;
      virtual void sendMapOutSignal(const uint32 regionId, const bool status) = 0;
      virtual void sendActivateContextSignal(const uint32 regionId, const uint32 appId, const uint32 contextId) = 0;
};


} //namespace Core
} //namespace App


#endif /* APPLICATION_SWITCH_SERVER_COMPONENT_INTERFACE_H */
