/**
 * @file         : ApplicationSurfaceInfoHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ApplicationSurfaceInfoHandlerInterface is to handle the
 *                 ApplicationSurfaceInfoHandler feature interface implementation.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef APPLICATION_SURFACE_INFO_HANDLER_INTERFACE_H
#define APPLICATION_SURFACE_INFO_HANDLER_INTERFACE_H


#include <asf/core/Types.h>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


/**
 * IApplicationSurfaceInfoHandler is used to
 *  - Provide interface impl between Users and ApplicationSurfaceInfoHandler.
 */
class IApplicationSurfaceInfoHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      IApplicationSurfaceInfoHandler() {}
      virtual ~IApplicationSurfaceInfoHandler() {}
      virtual uint32 getApplicationId(const uint32 surfaceId) const = 0;
};


} //namespace Core
} //namespace App


#endif /* APPLICATION_SURFACE_INFO_HANDLER_INTERFACE_H */
