/**
 * @file         : ApplicationSurfaceInfoHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : ApplicationSurfaceInfoHandler is to handle the application
 *                 surface information.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef APPLICATION_SURFACE_INFO_HANDLER_H
#define APPLICATION_SURFACE_INFO_HANDLER_H


#ifndef WIN32 /* Linux / Other OS env except Windows */
#include "pthread.h"
#endif
#include "ApplicationSurfaceInfoHandlerInterface.h"
#include <map>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


/**
 * ApplicationSurfaceInfoHandler is used to
 *  - Handle the application surface information.
 */
class ApplicationSurfaceInfoHandler : public IApplicationSurfaceInfoHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      ApplicationSurfaceInfoHandler();
      virtual ~ApplicationSurfaceInfoHandler();
      uint32 getApplicationId(const uint32 surfaceId) const;

   private:
      /**
       *  Member Typedefs Declaration
       */
      typedef ::std::multimap< uint32, uint32 > ApplicationsSurfaceInfo;
      /**
       *  Member Functions Declaration
       */
      ApplicationSurfaceInfoHandler(const ApplicationSurfaceInfoHandler& obj);
      ApplicationSurfaceInfoHandler& operator= (const ApplicationSurfaceInfoHandler& obj);
      bool isValidToInitApplicationsSurfaceInfo() const;
      void initApplicationsSurfaceInfo();

      inline void clear()
      {
         _applicationsSurfaceInfo.clear();
      }
      /**
       *  Member Variables Declaration
       */
      ApplicationsSurfaceInfo _applicationsSurfaceInfo;
#ifndef WIN32 /* Linux / Other OS env except Windows */
      static pthread_mutex_t _safeLock;
#endif
};


} //namespace Core
} //namespace App


#endif /* APPLICATION_SURFACE_INFO_HANDLER_H */
