/* ***************************************************************************************
 * FILE:          AppFlyInDefines.h
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  AppFlyIn.h is part of HMI-Base reference/demo/test applications
 *    COPYRIGHT:  (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef _APP_FLYIN_TYPES_H
#define _APP_FLYIN_TYPES_H

#include "ApplicationSwitchConst.h"
#include "AppHmi_MasterTypes.h"


#define APP_SWITCH_NAMESPACE bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch


class AppFlyInItem
{
   public:
      AppFlyInItem()
      {
         resetData();
      }

      ~AppFlyInItem()
      {
         resetData();
      }

      AppFlyInItem(const AppFlyInItem& obj)
      {
         resetData();
         *this = obj;
      }

      AppFlyInItem& operator= (const AppFlyInItem& obj)
      {
         if (this != (&obj))
         {
            resetData();
            _imageBg             = obj.getBgImage();
            _imageIcon           = obj.getIconImage();
            _imageBorder         = obj.getBorderImage();
            _disabledimageBg     = obj.getDisabledBgImage();
            _disabledimageIcon   = obj.getDisabledIconImage();
            _disabledimageBorder = obj.getDisabledBorderImage();
            _dynamicImageBg      = obj.getDynamicBgImage();
            _dynamicImageBorder  = obj.getDynamicBorderImage();
            _dynamicImageIcon    = obj.getDynamicIconImage();
            _buttonState         = obj.getButtonState();
            _targetContext       = obj.getTargetContext();
            _targetAppId         = obj.getTargetAppId();
            _itemIndex           = obj.getItemIndex();
         }
         return (*this);
      }

      void resetData()
      {
         _imageBg             = "";
         _imageIcon           = "";
         _imageBorder         = "";
         _disabledimageBg     = "";
         _disabledimageIcon   = "";
         _disabledimageBorder = "";
         _dynamicImageBg      = "";
         _dynamicImageBorder  = "";
         _dynamicImageIcon    = "";
         _buttonState         = BUTTON_STATE_ENABLED;
         _targetContext       = APP_SWITCH_NAMESPACE::enActivityIDs__eActivityID_NONE;
         _targetAppId         = APPID_APPHMI_UNKNOWN;
         _itemIndex           = ITEM_INVALID;
      }

      inline void setBgImage(const Candera::String& path)
      {
         _imageBg = path;
      }

      inline void setIconImage(const Candera::String& path)
      {
         _imageIcon = path;
      }

      inline void setBorderImage(const Candera::String& path)
      {
         _imageBorder = path;
      }

      inline void setDisabledBgImage(const Candera::String& path)
      {
         _disabledimageBg = path;
      }

      inline void setDisabledIconImage(const Candera::String& path)
      {
         _disabledimageIcon = path;
      }

      inline void setDisabledBorderImage(const Candera::String& path)
      {
         _disabledimageBorder = path;
      }

      inline void setButtonState(const uint8 state)
      {
         _buttonState = state;
      }

      inline void setTargetContext(const uint32 context)
      {
         _targetContext = context;
      }

      inline void setTargetApp(const uint32 appId)
      {
         _targetAppId = appId;
      }

      inline void setItemIndex(const uint32 index)
      {
         _itemIndex = index;
      }

      inline const Candera::String& getBgImage() const
      {
         return _imageBg;
      }

      inline const Candera::String& getIconImage() const
      {
         return _imageIcon;
      }

      inline const Candera::String& getBorderImage() const
      {
         return _imageBorder;
      }

      inline const Candera::String& getDisabledBgImage() const
      {
         return _disabledimageBg;
      }

      inline const Candera::String& getDisabledIconImage() const
      {
         return _disabledimageIcon;
      }

      inline const Candera::String& getDisabledBorderImage() const
      {
         return _disabledimageBorder;
      }

      inline uint8 getButtonState() const
      {
         return _buttonState;
      }

      inline uint32 getTargetContext() const
      {
         return _targetContext;
      }

      inline uint32 getTargetAppId() const
      {
         return _targetAppId;
      }

      inline uint32 getItemIndex() const
      {
         return _itemIndex;
      }

      inline void setDynamicBgImage(const Candera::String& path)
      {
         _dynamicImageBg = path;
      }

      inline void setDynamicIconImage(const Candera::String& path)
      {
         _dynamicImageIcon = path;
      }

      inline void setDynamicBorderImage(const Candera::String& path)
      {
         _dynamicImageBorder = path;
      }

      inline const Candera::String& getDynamicBgImage() const
      {
         return _dynamicImageBg;
      }

      inline const Candera::String& getDynamicIconImage() const
      {
         return _dynamicImageIcon;
      }

      inline const Candera::String& getDynamicBorderImage() const
      {
         return _dynamicImageBorder;
      }

   private:
      Candera::String _imageBg;
      Candera::String _imageIcon;
      Candera::String _imageBorder;
      Candera::String _disabledimageBg;
      Candera::String _disabledimageIcon;
      Candera::String _disabledimageBorder;
      Candera::String _dynamicImageBg;
      Candera::String _dynamicImageBorder;
      Candera::String _dynamicImageIcon;
      uint8 _buttonState;
      uint32 _targetContext;
      uint32 _targetAppId;
      uint32 _itemIndex;
};


typedef ::std::vector < AppFlyInItem > AppFlyInItemInfo;
typedef ::std::map < uint32, AppFlyInItemInfo > AppFlyInsInfo;


class AppFlyInItemOrder
{
   public:
      AppFlyInItemOrder()
      {
         resetData();
      }

      ~AppFlyInItemOrder()
      {
         resetData();
      }

      AppFlyInItemOrder(const AppFlyInItemOrder& obj)
      {
         resetData();
         *this = obj;
      }

      AppFlyInItemOrder& operator= (const AppFlyInItemOrder& obj)
      {
         if (this != (&obj))
         {
            resetData();
            _appId           = obj.getAppId();
            _itemIndexVector = obj.getItemIndexVector();
         }
         return (*this);
      }

      void resetData()
      {
         _appId         = APPID_APPHMI_UNKNOWN;
         _itemIndexVector.clear();
      }

      inline void setApplicationId(const uint32 id)
      {
         _appId = id;
      }

      inline void setItemIndexVector(const ::std::vector<uint32>& index)
      {
         _itemIndexVector = index;
      }

      inline uint32 getAppId() const
      {
         return _appId;
      }

      inline const ::std::vector<uint32>& getItemIndexVector() const
      {
         return _itemIndexVector;
      }

   private:
      uint32 _appId;
      ::std::vector<uint32> _itemIndexVector;
};


typedef ::std::vector < AppFlyInItemOrder > AppFlyInItemOrderInfo;
typedef ::std::map < uint32, AppFlyInItemOrderInfo > AppFlyInsOrderInfo;


#endif //_APP_FLYIN_TYPES_H
