/* ***************************************************************************************
 * FILE:          AppFlyInDefines.h
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  AppFlyIn.h is part of HMI-Base reference/demo/test applications
 *    COPYRIGHT:  (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef _APP_FLYIN_DEFINES_H
#define _APP_FLYIN_DEFINES_H


#define BEGIN_CONFIGURE_SHORTCUT_INFO()                                                                   \
::std::map < uint32, AppFlyInsInfo > listInfo;

#define BEGIN_SHORTCUT_LIST(_listId_, _cond_)                                                             \
if (_cond_)                                                                                               \
{                                                                                                         \
   uint32 listId = _listId_;                                                                              \
   AppFlyInsInfo regionInfo;

#define BEGIN_SHORTCUT_REGION(_regionId_, _cond_)                                                         \
   if (_cond_)                                                                                            \
   {                                                                                                      \
      uint32 regionId = _regionId_;                                                                       \
      AppFlyInItemInfo itemInfo;

#define BEGIN_SHORTCUT_LIST_ITEM_INFO(_cond_)                                                             \
      if (_cond_)                                                                                         \
      {                                                                                                   \
         AppFlyInItem info;

#define ADD_SHORTCUT_ITEM_ID(_id_)                                                                        \
         info.setItemIndex(_id_);

#define ADD_SHORTCUT_ITEM_BG_IMAGE(_imageBg_)                                                             \
         info.setBgImage(_imageBg_);

#define ADD_SHORTCUT_ITEM_ICON_IMAGE(_imageIcon_)                                                         \
         info.setIconImage(_imageIcon_);

#define ADD_SHORTCUT_ITEM_BORDER_IMAGE(_imageBorder_)                                                     \
         info.setBorderImage(_imageBorder_);

#define ADD_SHORTCUT_ITEM_DISABLED_BG_IMAGE(_disabledimageBg_)                                            \
         info.setDisabledBgImage(_disabledimageBg_);

#define ADD_SHORTCUT_ITEM_DISABLED_ICON_IMAGE(_disabledimageIcon_)                                        \
         info.setDisabledIconImage(_disabledimageIcon_);

#define ADD_SHORTCUT_ITEM_DISABLED_BORDER_IMAGE(_disabledimageBorder_)                                    \
         info.setDisabledBorderImage(_disabledimageBorder_);

#define ADD_SHORTCUT_ITEM_TARGET_CONTEXT(_targetContext_)                                                 \
         info.setTargetContext(_targetContext_);

#define ADD_SHORTCUT_ITEM_TARGET_APP(_targetApp_)                                                         \
         info.setTargetApp(_targetApp_);

#define ADD_SHORTCUT_ITEM_BUTTON_STATE(_buttonState_)                                                     \
         info.setButtonState(_buttonState_);

#define END_SHORTCUT_LIST_ITEM_INFO()                                                                     \
         itemInfo.push_back(info);                                                                        \
      }

#define END_SHORTCUT_REGION()                                                                             \
		regionInfo.insert(::std::pair<uint32, AppFlyInItemInfo>(regionId, itemInfo));                              \
   }

#define END_SHORTCUT_LIST()                                                                               \
   listInfo.insert(::std::pair<uint32, AppFlyInsInfo>(listId, regionInfo));                                                 \
}


#define END_CONFIGURE_SHORTCUT_INFO()                                                                     \
return listInfo;

/*
 * Configure AppFlyIn List Order for current visible Scene
 */


#define BEGIN_CONFIGURE_LIST_ORDER_INFO()                                                                 \
::std::map < uint32, AppFlyInsOrderInfo > listInfo;

#define BEGIN_LIST_ORDER(_listId_, _cond_)                                                                \
if (_cond_)                                                                                               \
{                                                                                                         \
   uint32 listId = _listId_;                                                                              \
   AppFlyInsOrderInfo regionInfo;

#define BEGIN_REGION_ORDER(_regionId_, _cond_)                                                            \
   if (_cond_)                                                                                            \
   {                                                                                                      \
      uint32 regionId = _regionId_;                                                                       \
      AppFlyInItemOrderInfo itemInfo;

#define BEGIN_APP_LIST_ITEM_INFO(_appId_, _cond_)                                                         \
      if (_cond_)                                                                                         \
      {                                                                                                   \
         AppFlyInItemOrder info;                                                                          \
         info.setApplicationId(_appId_);                                                                  \
         ::std::vector<uint32> temp;

#define ADD_SHORTCUT_ITEM_INDEX(_id_)                                                                     \
         temp.push_back(_id_);

#define END_APP_LIST_ITEM_INFO()                                                                          \
         info.setItemIndexVector(temp);                                                                   \
         itemInfo.push_back(info);                                                                        \
      }

#define END_REGION_ORDER()                                                                                \
      regionInfo.insert(::std::pair<uint32, AppFlyInItemOrderInfo>(regionId, itemInfo));                                            \
   }

#define END_LIST_ORDER()                                                                                  \
   listInfo.insert(::std::pair<uint32, AppFlyInsOrderInfo>(listId, regionInfo));                                                 \
}


#define END_CONFIGURE_LIST_ORDER_INFO()                                                                   \
return listInfo;


#define BEGIN_CONFIGURE_APPLICATION_CONTEXT_INFO()                                                        \
::std::map < uint32, ::std::vector< uint32 > > listInfo;

#define BEGIN_APP_CONTEXT_ITEM_INFO(_appId_, _cond_)                                                      \
      if (_cond_)                                                                                         \
      {                                                                                                   \
         uint32 appId = _appId_;                                                                          \
         ::std::vector<uint32> temp;

#define ADD_APP_CONTEXT_ITEM(_id_)                                                                        \
         temp.push_back(_id_);

#define END_APP_CONTEXT_ITEM_INFO()                                                                       \
         listInfo.insert(::std::pair< uint32, ::std::vector< uint32 > >(appId, temp));                    \
      }

#define END_CONFIGURE_APPLICATION_CONTEXT_INFO()                                                          \
return listInfo;


#endif //_APP_FLYIN_DEFINES_H
