/* ***************************************************************************************
* FILE:          CGIAppController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CGIAPPCONTROLLER_H
#define CGIAPPCONTROLLER_H
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_CameraStateMachine.h"
#include "AppHmi_CameraDatabinding.h"
//#include "CameraMain.h"
#include "App/Core/CameraMain/CameraMain.h"
#include "Common/CGIAppController/CGIAppControllerProject.h"

using namespace App::Core;


class CGIAppController : public CGIAppControllerProject
{
   courier_messages:
      COURIER_MSG_MAP_BEGIN(0)
      COURIER_CASE_DUMMY_ENTRY()
      ON_COURIER_MESSAGE(Courier::ActivationResMsg)
      ON_COURIER_MESSAGE(HKStatusChangedUpdMsg)
      ON_COURIER_MESSAGE(RenderingCompleteMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(CGIAppControllerProject)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

   public:
      //virtual ~CGIAppController();
      using CGIAppControllerProject::onCourierMessage;
      virtual bool onCourierMessage(const HKStatusChangedUpdMsg& msg);
      bool onCourierMessage(const RenderingCompleteMsg& msg);
      CGIAppController(hmibase::services::hmiappctrl::ProxyHandler& proxyHandler) : CGIAppControllerProject(proxyHandler) {}
   private:
      //CameraMain* hCameraMain;
      //CGIAppController();
};


#endif // CGIAPPCONTROLLER_H
