/**
 * @file        : AppViewSettings.cpp
 * @addtogroup  : AppHmi_Camera
 * @brief       : If in this class no special handling is defined, the implementation of the
 * 				  base class IAppViewSettings will be used by ScreenBrokerClient
 * @copyright   : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 */

#include "AppViewSettings.h"
/**
 * If in this class no special handling is defined, the implementation of the
 * base class IAppViewSettings will be used by ScreenBrokerClient (as part of
 * libapphmi_fw_appbase-asf_a.a).
 * If this application needs special handling, it can be added to this class.
 *
 * The base class IAppViewSettings provides:
 * - the popup presentation arguments
 * - the different request IDs to show/hide a surface
 * - the different request IDs to show/hide a popup dependent on popup
 *   presentation arguments)
 * which are needed by ScreenBorkerClient to communicate with ScreenBroker.
*/
