/**************************************************************************************
* @file         : VehicleClientHandler.h
* @author       : ECG5- shanmugapriya Murugan
* @addtogroup   :
* @brief        : Class contains necessary business logic required to handle source selection.
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef VehicleClientHandler_H
#define VehicleClientHandler_H

#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
#define LANGNO  19
#endif

#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
#define LANGNO  22
#endif

#include "asf/core/Timer.h"
#include "rvc_cca_fiProxy.h"
#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppHmi_CameraStateMachine.h"
#include "AppBase/HallComponentBase.h"
#include "AppBase/ServiceAvailableIF.h"
#include "CameraDefines.h"
#include <AppHmi_CameraMessages.h>
#include "CameraDataBindingHandler.h"
#include "AppHmi_CameraStateMachine.h"
#include "AppHmi_CameraDatabinding.h"
#include "ProjectPluginMsgs.h"
#include "App/Core/NanoMessageClientHandler/NanoMsgClientHandler.h"
#include "KDSHandler.h"
//#include "App/Core/HmiInfoService/HmiInfoServiceServerComponent.h"

namespace App {
namespace Core {
using namespace VEHICLE_MAIN_FI;
using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types;

class VehicleClientHandler
   : public ::asf::core::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ActCam1CallbackIF //1 - , 0
   , public ActCam2CallbackIF
   , public ActCam3CallbackIF
   , public ActCam4CallbackIF
   , public ActCam5CallbackIF
   , public ActCam6CallbackIF
   , public ActCam7CallbackIF
   , public ActCam8CallbackIF
   , public ActCam9CallbackIF
   , public ActCam10CallbackIF
   , public Cam1ManActCallbackIF
   , public Cam2ManActCallbackIF
   , public Cam3ManActCallbackIF
   , public Cam4ManActCallbackIF
   , public Cam5ManActCallbackIF
   , public Cam6ManActCallbackIF
   , public Cam7ManActCallbackIF
   , public Cam8ManActCallbackIF
   , public Cam9ManActCallbackIF
   , public Cam10ManActCallbackIF
   , public CamSplitQuadCallbackIF
   , public RearCamReqCallbackIF
   , public CamTxtCallbackIF
   , public ReverseSignalStatusCallbackIF
   , public LanguageSyncSourceCallbackIF
   , public SetLanguageCallbackIF
   , public LanguageCallbackIF
   , public DispCamClsCallbackIF
   , public ReverseGearCallbackIF
   , public SpeedCallbackIF
   , public ParkingBreakSwitchCallbackIF
   , public ::asf::core::TimerCallbackIF
{
   public:
      virtual ~VehicleClientHandler();
      static VehicleClientHandler* getInstance()
      {
         if (NULL == m_poVehicleClientHandler)
         {
            m_poVehicleClientHandler = new VehicleClientHandler();
         }

         return m_poVehicleClientHandler;
      }
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onActCam1Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam1Error >& error);
      virtual void onActCam1Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam1Status >& status);

      virtual void onActCam2Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam2Error >& error);
      virtual void onActCam2Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam2Status >& status);

      virtual void onActCam3Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam3Error >& error);
      virtual void onActCam3Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam3Status >& status);

      virtual void onActCam4Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam4Error >& error);
      virtual void onActCam4Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam4Status >& status);

      virtual void onActCam5Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam5Error >& error);
      virtual void onActCam5Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam5Status >& status);

      virtual void onActCam6Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam6Error >& error);
      virtual void onActCam6Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam6Status >& status);

      virtual void onActCam7Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam7Error >& error);
      virtual void onActCam7Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam7Status >& status);

      virtual void onActCam8Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam8Error >& error);
      virtual void onActCam8Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam8Status >& status);

      virtual void onActCam9Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam9Error >& error);
      virtual void onActCam9Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam9Status >& status);

      virtual void onActCam10Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam10Error >& error);
      virtual void onActCam10Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ActCam10Status >& status);

      virtual void onCamSplitQuadError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< CamSplitQuadError >& error);
      virtual void onCamSplitQuadStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< CamSplitQuadStatus >& status);

      virtual void onCam1ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam1ManActError >& error);
      virtual void onCam1ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam1ManActResult >& result);

      virtual void onCam2ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam2ManActError >& error);
      virtual void onCam2ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam2ManActResult >& result);

      virtual void onCam3ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam3ManActError >& error);
      virtual void onCam3ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam3ManActResult >& result);

      virtual void onCam4ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam4ManActError >& error);
      virtual void onCam4ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam4ManActResult >& result);

      virtual void onCam5ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam5ManActError >& error);
      virtual void onCam5ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam5ManActResult >& result);

      virtual void onCam6ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam6ManActError >& error);
      virtual void onCam6ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam6ManActResult >& result);

      virtual void onCam7ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam7ManActError >& error);
      virtual void onCam7ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam7ManActResult >& result);

      virtual void onCam8ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam8ManActError >& error);
      virtual void onCam8ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam8ManActResult >& result);

      virtual void onCam9ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam9ManActError >& error);
      virtual void onCam9ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam9ManActResult >& result);

      virtual void onCam10ManActError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam10ManActError >& error);
      virtual void onCam10ManActResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< Cam10ManActResult >& result);

      virtual void onCamTxtError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< CamTxtError >& error);
      virtual void onCamTxtStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< CamTxtStatus >& status);

      virtual void onRearCamReqError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< RearCamReqError >& error);
      virtual void onRearCamReqStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< RearCamReqStatus >& status);

      void onReverseSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusError >& /*error*/);
      void onReverseSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusStatus >& status);

      void onDispCamClsError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< DispCamClsError >& /*error*/);
      void onDispCamClsResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< DispCamClsResult >& result);

      void onSpeedStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SpeedStatus >& status);
      void onSpeedError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SpeedError >& /*error*/);

      virtual void onParkingBreakSwitchError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ParkingBreakSwitchError >& error);
      virtual void onParkingBreakSwitchStatus(const ::boost::shared_ptr<VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ParkingBreakSwitchStatus >& status);

      struct LanguageTable
      {
         int LangIndex;
         std::string LangString;
         uint8 hmiindex;
      };

      void onLanguageStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< LanguageStatus >& status);
      void onLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< LanguageError >& /*error*/);

      void onSetLanguageResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< SetLanguageResult >& result);
      void onSetLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SetLanguageError >& /*error*/);

      void onLanguageSyncSourceStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< LanguageSyncSourceStatus >& result);
      void onLanguageSyncSourceError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< LanguageSyncSourceError >& /*error*/);

      void onReverseGearError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ReverseGearError >& error);
      void onReverseGearStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ReverseGearStatus >& status);
      std::string getLanguageId(int index, uint8& hmiImageIndex);
      void readLanguageOnStartUp();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_CAMERA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_END()

      //static void TraceCmd_onCameraTextStatus(uint64 camValues);
      static void TraceCmd_onCameraTextStatus(int c1, int c2, int c3, int c4, int c5, int c6, int c7, int c8);
      static void TraceCmd_onCameraactcamStatus(int camValues, enCameraCAN camtype, std::string camSrcName);
      //void Testcode(uint64 value);
      void Testcode(int c1, int c2, int c3, int c4, int c5, int c6, int c7, int c8);
      void vUpdatetoCANfromHMI(std::string strCamSrc, uint8 status);
      void Cam1ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam2ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam3ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam4ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam5ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam6ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam7ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam8ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam9ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      void Cam10ManAct_Deact(std::string CamSrcString, uint8 actDeactStatus);
      bool bCheckSrcActiveInEitherRegion(std::string validateSrcName);

      //CRQ 1366236 Handle(Disable) Camera Power Management at EvoBus in the Cabin Region during MAP OUT/CMR VIDEO/USB VIDEO Enable

      void vDeactivateAllCameraManActCabin();
      void vDeactivateSecondaryNdTeritoryCameraManActInCabin();
      void vDeactivateTeritoryCameraManActInCabin();

      //void checkNanoMsgDigPinIsActive();
      //validite functions for speed value and parking brake status
      bool bGetSpeedAndParkBrakeValidityStatus();

      std::string regioncheck(int regionId);
      void vsendDispCamCls_Rq(int Value);
      bool GetCANUpdate();
      void SetCANUpdate(bool toggle);
      bool m_CANupdate;
      void HandleCamRequest(uint8 camValue, enCameraCAN currentCam /*= CAMOFF*/, std::string cameraSrcName);
      CameraDataBindingHandler* m_poCameraDataBindingHandler;
      uint16 m_parkBrakeStatus;
      uint16 m_speedValue;
      bool m_camTextStatusValue;
      bool m_SpeedLockActive = false;
      void updateSpeedAndParkingStatusValue(uint16 speedValue, uint16 parkingBrakeStatus);
      bool getSpeedAndParkingStatus();
      void vPerformActCamActivation(int index);
      struct stCamCANActivation
      {
         enCameraCAN cameraName;
         int actStatus;
         std::string camSrcName;
      };
      vector<stCamCANActivation> vecStCANCameraOnStartup;
      void checkAnyCameraActiveOnStartup();
      int m_camActivationValue = KDSHandler::poGetInstance()->u8GetCameraActivationValue();

      /** Instance for the timer */
      asf::core::Timer _rvcTimer;
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      void vRequestForCameraActivationOnTimeout();
      void sendCamTxtIdUpdateToHMI(uint64 CANtextIdvalue);
      void verifyCANCameraActive();
      void vContextSwitchRequestToCameraScreenViaCANTrigger();
      void sendActivateCam1ManActStartRequest();

      vector<stCamStackingInfo> vecStCameraStackingInfo;
      bool checkStackInfoIsEmpty();
      vector<stCamStackingInfo> getVecStCameraStackingInfo();
      bool vSearchDeleteRestore_Camera(std::string searchStr, int triggertype);
      void printData(std::vector<stCamStackingInfo>& vCamStackingInfo);
      void storeInfoFromListAndTile(int screenID, std::string strCamSrc, const bool streamStatus);
      void vecStCameraStackingPushUpdate(stCamStackingInfo stackInfo);
      void clearvecStCameraStackingInfo();


#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      LanguageTable LanguageMappingTable[LANGNO] =
      {
         { 12, "en_GB", 0 },         //UK_English
         { 23, "de_DE", 1 },         //German
         { 10, "nl_NL", 2 },         //Dutch
         { 21, "fr_FR", 3 },         //EU_French
         { 29, "it_IT", 4 },         //Italian
         { 46, "es_SP", 5 },         //EuropeanSpanish
         { 39, "pt_PT", 6 },         //EuropeanPortugese(port)
         { 27, "hu_HU", 7 },         //Hungarian
         { 42, "ru_RU", 8 },         //Russian
         { 8, "cs_CS", 9 },          //Czech
         { 9, "da_DA", 10},          // Danish
         { 35, "nb_NB", 11},         // Norwegian
         { 38, "pl_PL", 12},         // Polish
         { 49, "sv_SE", 13},         // Swedish
         { 24, "el_GR", 14},         // Greek
         {52, "tr_TR", 15},		  // Turkish
         { 22, "fr_CA", 16 },        // CanadianFrench
         { 47, "es_LA", 17},          // LatinAmericanSpanish
         { 13, "en_US", 18},          //  US_English
      };
#endif

#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      LanguageTable LanguageMappingTable[LANGNO] =
      {
         { 12, "en_GB", 0 },         //UK_English
         { 23, "de_DE", 1 },         //German
         { 10, "nl_NL", 2 },         //Dutch
         { 21, "fr_FR", 3 },         //EU_French
         { 29, "it_IT", 4 },         //Italian
         { 46, "es_SP", 5 },         //EuropeanSpanish
         { 39, "pt_PT", 6 },         //EuropeanPortugese(port)
         { 27, "hu_HU", 7 },         //Hungarian
         { 8, "cs_CS", 9 },         ; //Czech
         { 9, "da_DA", 10},         ; // Danish
         { 35, "nb_NB", 11},         // Norwegian
         { 38, "pl_PL", 12},         // Polish
         { 49, "sv_SE", 13},         // Swedish
         { 24, "el_GR", 14},         // Greek
         { 52, "tr_TR", 15},		 // Turkish
         { 47, "es_LA", 17},          // LatinAmericanSpanish
         { 3, "bg_BG", 0 },    //  US_English- DEFAULT
         { 45, "sl_SI", 0  },    //  US_English
         { 44, "sk_SK", 0 },    //  US_English
         { 41, "ro_RO", 0  },    //  US_English
         { 19, "fi_FI", 0 },    //  US_English
         { 7, "hr_HR", 0  }
      };
#endif


   private:
      VehicleClientHandler();
      static VehicleClientHandler* m_poVehicleClientHandler;
      void onUpdReverseGearMANACT(std::string strCamSrc, const bool status);
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> m_vehicleProxy;
      ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy > m_poRvcFiProxy;
      uint64 currentCamTextID;
      uint64 previousCamTextID;
      // bool digitalInputFlagInRvcMode;


//Camera Port [Camera Port Position][Dig Pin Value]
//Camera Port [CMP][D_PIN]
// D_PIN-0 and CMP_0 is dummy
//		     							  D_PIN-0  D_PIN-1  D_PIN-2  D_PIN-3   D_PIN-3
      std::string cameraPortPosSrcName[4][5] = {{"",    ""		,     ""	,    ""	,    ""	   },    //CMP_0
         {"", "CMP1_CAM1", "CMP1_CAM2", "CMP1_CAM3", "CMP1_CAM4"}, //CMP_1
         {"", "CMP2_CAM1", "CMP2_CAM2", "CMP2_CAM3", "CMP2_CAM4"}, //CMP_2
         {"", "CMP3_CAM1", "CMP3_CAM2", "CMP3_CAM3", "CMP3_CAM4"}  //CMP_3
      };
};


} // namespace Core
} // namespace App

#endif
