#ifndef KDSHandler_H
#define KDSHandler_H

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif

namespace App {
namespace Core {

class KDSHandler
{
   public:
      virtual ~KDSHandler();

      static KDSHandler* poGetInstance()
      {
         if (NULL == m_poKDSHandler)
         {
            m_poKDSHandler = new KDSHandler();
         }
         return m_poKDSHandler;
      }

      void vReadKDSConfigValues();

      void readKDSCameraBlackScreenTimeValue();
      void readKDSCameraBlackScreenFeatureValue();

      tU8 getVariantInfoFromKDS();
      tU8 u8GetCabinCameraKDSValue();
      tU8 u8GetCameraActivationValue();
      tU8 u8GetRvcMsgPositionValue();
      tU8 u8GetCameraBlackScreenFeatureValue();
      tU16 u16GetCameraBlackScreenTimeValue();

      tU8 m_u8CabinCameraKDSValue;
      tU8 m_u8GetCameraActivation;
      tU8 m_u8RvcMsgPositionValue;
      tU8 m_variantInfo;

      tU16 m_cameraBlackScreenTimeOut;
      tU8 m_isBlackScreenFeatureEnabled;

   private:
      static KDSHandler* m_poKDSHandler;
      KDSHandler();
      KDSHandler(const KDSHandler&);
      KDSHandler& operator =(const KDSHandler&);
};


}
}


#endif
