/**************************************************************************************
* @file         : CameraMain.h
* @author       : ECG5- Deepak
* @addtogroup   :
* @brief        : Class contains necessary business logic required to handle AM FM Camera data.
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CameraMain_H
#define CameraMain_H

#include <AppHmi_CameraMessages.h>
#include "HmiTranslation_TextIds.h"
#include "CameraDataBindingHandler.h"
#include "CgiExtensions/ImageLoader.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_CameraStateMachine.h"
#include "AppHmi_CameraDatabinding.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "PluginConstants.h"
#include "ProjectPluginMsgs.h"
#include "VehicleClientHandler/VehicleClientHandler.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "CameraDefines.h"
#include "Common/VariantHandling/VariantHandling.h"
#include "rvc_cca_fiProxy.h"
#include "AVRoutingParser.h"
#include "KDSHandler.h"
#include "asf/core/Timer.h"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif


namespace App {
namespace Core {

using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types;
using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;

class CameraMain:
   public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ActiveRegionIdCallbackIF
   , public Sig_ActivateContextCallbackIF
   , public SetSystemStatusCallbackIF
   , public ::asf::core::TimerCallbackIF
{
   public:
      virtual ~CameraMain();
      bool GetToggleValue();

      void RequestPluginForCabinSplitViewSel(enCamera camSrc, int splitType);
      bool onCourierMessage(const ContextToMaster& corfoMsg);
      bool onCourierMessage(const CameraBackButtonMsg& corfoMsg);
      bool onCourierMessage(const CabinSourceMsg& corfoMsg);
      bool onCourierMessage(const CameraToggleButton& corfoMsg);
      bool onCourierMessage(const CameraExitMsg& corfoMsg);
      bool onCourierMessage(const CabinCameraExitMsg& corfoMsg);
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& oMsg);
      bool onCourierMessage(const ButtonMainSrcActivate& corfoMsg);
      bool onCourierMessage(const ButtonMainSrcCabinActivate& corfoMsg);
      bool onCourierMessage(const NextCameraActivate& corfoMsg);
      bool onCourierMessage(const PreviousCameraActivate& corfoMsg);
      bool onCourierMessage(const CameraStreamStopMsg& corfoMsg);
      bool onCourierMessage(const CameraStreamStartMsg& corfoMsg);
      bool onCourierMessage(const PluginUpdateRespMsg& oMsg);
      bool onCourierMessage(const PluginEndStationListUpdateMsg& oMsg);
      bool onCourierMessage(const PluginListUpdateRespMsg& oMsg);
      bool onCourierMessage(const SplitViewLeftCamMsg& msg);
      bool onCourierMessage(const SplitViewRightCamMsg& msg);
      bool onCourierMessage(const CameraSplitStreamStartMsg& corfoMsg);
      bool onCourierMessage(const ButtonMixedSourceMsg& corfoMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_CAMERA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(CameraBackButtonMsg)
      ON_COURIER_MESSAGE(CabinSourceMsg)
      ON_COURIER_MESSAGE(CameraExitMsg)
      ON_COURIER_MESSAGE(CabinCameraExitMsg)
      ON_COURIER_MESSAGE(ContextToMaster)
      ON_COURIER_MESSAGE(CameraToggleButton)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      ON_COURIER_MESSAGE(ButtonMainSrcActivate)
      ON_COURIER_MESSAGE(ButtonMainSrcCabinActivate)
      ON_COURIER_MESSAGE(NextCameraActivate)
      ON_COURIER_MESSAGE(PreviousCameraActivate)
      ON_COURIER_MESSAGE(CameraStreamStopMsg)
      ON_COURIER_MESSAGE(CameraStreamStartMsg)
      ON_COURIER_MESSAGE(PluginUpdateRespMsg)
      ON_COURIER_MESSAGE(ActiveRenderedView)
      ON_COURIER_MESSAGE(PluginEndStationListUpdateMsg)
      ON_COURIER_MESSAGE(PluginListUpdateRespMsg)
      ON_COURIER_MESSAGE(SplitViewLeftCamMsg)
      ON_COURIER_MESSAGE(SplitViewRightCamMsg)
      ON_COURIER_MESSAGE(CameraSplitStreamStartMsg)
      ON_COURIER_MESSAGE(ButtonMixedSourceMsg)

      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
      uint8 getRegionValue();
      uint8 getCurrentCamView();
      uint8 m_control_id;
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                         const ::boost::shared_ptr< ActiveRegionIdError >& error) ;

      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                          const ::boost::shared_ptr< ActiveRegionIdUpdate >& update) ;

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                              const ::boost::shared_ptr< Sig_ActivateContextError >& error);

      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
            const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      void onSetSystemStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetSystemStatusError >& error);
      void onSetSystemStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetSystemStatusResult >& result);
      static CameraMain* poGetInstance()
      {
         if (NULL == m_poCameraMain)
         {
            m_poCameraMain = new CameraMain();
         }

         return m_poCameraMain;
      }
      void vRequestStopCameraStream();
      void vRequestStartCameraStream();
      bool vRequestStopCabinCameraStream();
      void HandleRequestCabin();
      int vGetActivityID();
      void sendPluginRequestSplitView(const char* pluginName, const char* ctrlBlockName, uint16 sourceid, uint16 sinkid, int splitType);
      void vStartCameraStream();
      _Src getSource();
      void setSource(_Src source);
      void setToggleValue(bool toggle);
      void getSplitConfigData();
      void sendStoreContextRequest(uint16 activityID);
      bool onCourierMessage(const ActiveRenderedView& msg);
      bool vAppflyinStatusInfo(bool FlyInStatus);
      uint16 getCameraActivityID(std::string viewid);
      std::vector <std::string> m_subSystemAvailability;
      bool getCurrentSubSystemAvailability(std::string strCurrentVal);
      CameraDataBindingHandler* m_poCameraDataBindingHandler;

      vector<int> cameraTextIdFromXML;
      vector<stCameraData> vecCamData;
      map<int, stCameraData> camHexCamData;
      void printStructure();
      vector<int> getCameraTextIds();

      static void TraceCmd_setCamTextFor1CMP(uint16_t cam1, uint16_t cam2, uint16_t cam3, uint16_t cam4, uint16_t ipcam);
      static void TraceCmd_setCamTextFor2CMP(uint16_t cam1, uint16_t cam2, uint16_t cam3, uint16_t cam4, uint16_t cam5, uint16_t cam6, uint16_t cam7, uint16_t ipcam1, uint16_t ipcam2);
      static void TraceCmd_setCamTextFor3CMP(uint16_t cam1, uint16_t cam2, uint16_t cam3, uint16_t cam4, uint16_t cam5, uint16_t cam6, uint16_t cam7, uint16_t cam8, uint16_t cam9, uint16_t cam10, uint16_t ipcam1, uint16_t ipcam2, uint16_t ipcam3);

      void TestDataToHMI_1CMP(uint16_t cam1, uint16_t cam2, uint16_t cam3, uint16_t cam4, uint16_t ipcam);
      void TestDataToHMI_2CMP(uint16_t cam1, uint16_t cam2, uint16_t cam3, uint16_t cam4, uint16_t cam5, uint16_t cam6, uint16_t cam7, uint16_t ipcam1, uint16_t ipcam2);
      void TestDataToHMI_3CMP(uint16_t cam1, uint16_t cam2, uint16_t cam3, uint16_t cam4, uint16_t cam5, uint16_t cam6, uint16_t cam7, uint16_t cam8, uint16_t cam9, uint16_t cam10, uint16_t ipcam1, uint16_t ipcam2, uint16_t ipcam3);

      vector<stCameraData> getCamDataStructure();
      void vOnReceiveCameraList(tVecCamData vecCamDataToHmi);
      void sendPluginRequestToAVDECC(const char* pluginName, uint16 ControlId, uint16 position, std::string cameraSourceName);
      bool SetkdsheaderfooterValue(bool kdsheaderfooter);
      bool Currentkdsheaderfooterupdate();
      int m_CMPPrevCount;
      int m_CMPCount;
      std::string _strSplitCamSrcName[3] = {"cockpitSplitView1", "cockpitSplitView2", "cockpitSplitView3"};
      std::string getSplitCamName(std::string strSplitCamSrcName, int pos, int selection);
      std::string m_selectedSplitSource;
      int m_CMPPosition;
      void setSplitCamSourceAndPosition(std::string camSrcName, int pos);
      void setMixToggleFlag(int toggle);
      bool getCabinTileCameraToggleStatus();
      bool checkAllCamportDeviceAccesiblity();
      tclAvRoutingParser* _avRoutingParser;

      asf::core::Timer _camBlkScreen_Timer;
      void stopCameraBlackScreenTimer(void);
      void startCameraBlackScreenTimer(void);
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      void micIsDeActivated();
      void micDeactivationStopStream();
      void micIsActivated();
      void hardKeyHomeCabin(bool hkValue);

      void requestToAbruptPrompt();
   private:
      friend class CameraConfig;
      friend class XMLDocParser;
      uint8 m_u8activeRegion;
      _Src m_sourceID;
      bool m_ToggleVisible;
      bool m_toggle;
      bool m_MixSrctoggle;
      bool m_CamVisible;
      uint8 SelectedIndex = 0;

      bool currentKdsValue;
      uint8 m_activityID = 0;
      bool m_streamactive = false;
      static CameraMain* m_poCameraMain;
      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchProxy;
      typedef std::map<uint8, _Src > srcIdCabinMap;
      typedef std::map<uint8, uint8 > srcIdCockpitMap;
      srcIdCockpitMap m_doorViewCockpitMap, m_surveillanceViewCockpitMap, m_surroundViewCockpitMap, m_rearViewCockpitMap;
      srcIdCabinMap m_doorViewCabinMap, m_surveillanceViewCabinMap, m_surroundViewCabinMap, m_rearViewCabinMap, m_ScenicViewCabinMap;
      typedef std::map< uint8, std::vector<uint8> > splitViewSrcIdCabinMap;
      typedef std::map< uint8, std::vector<uint8> > splitViewCockpitMap;
      splitViewSrcIdCabinMap m_splitViewCabinMap;
      splitViewCockpitMap m_splitViewCockpitMap;
      CameraMain();
      CameraMain(const CameraMain&);
      CameraMain& operator =(const CameraMain&);
      bool checkCabinSplitCamAvailability(splitViewSrcIdCabinMap& currentsrcIdMap, const uint8& cabinButton);
      bool checkCockpitSplitCamAvailability(splitViewCockpitMap& currentsrcIdMap, const uint8& cabinButton);

      uint32 cameraBlackScreenDelayTime ;

      _Src getCabinSplitSrc(uint8 cameraButton);
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;//applicationSwitch
      ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy > m_poRvcFiProxy;
      DECLARE_CLASS_LOGGER();
      // bool rxdcurrentkdsheaderfooter;
      uint8 m_RvcMsgPositionInfo;

      uint32 m_pau8DelayTimeValue;
      bool hardKeyHomeCabinvalue;
      VariantHandling* _variantHandling;
};


} // namespace Core
} // namespace App


#endif
