/**************************************************************************************
* @file         : CameraMain.h
* @author       : ECH2- Somanath Baddi
* @addtogroup   :
* @brief        : Class contains necessary business logic required to handle AM FM Camera data.
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CameraListHandler_H
#define CameraListHandler_H
#include "AppHmi_CameraDatabinding.h"
#include "CameraDataBindingHandler.h"

#include <iostream>
#include <iterator>
#include <map>
#include "Widgets/2D/List/Data/ListDataProviderBuilder.h"
#include "HmiTranslation_TextIds.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppHmi_CameraStateMachine.h"
#include "CameraDefines.h"
#include "rvc_cca_fiProxy.h"
#include <string>
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include <sstream>
#include <boost/lexical_cast.hpp>
#include "AVRoutingParser.h"

#include "CgiExtensions/ImageLoader.h"


using namespace std;
namespace App {
namespace Core {

class CameraListHandler:
   public StartupSync::PropertyRegistrationIF
   , public ListImplementation
{
   public:
      virtual ~CameraListHandler();
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      tSharedPtrDataProvider getCameraProfileList();
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& listDataInfo);
      void camListSelectedIndex(uint32 selectedIndex, activatedScreen screenID);
      static CameraListHandler* m_poCameraListHandler;

      DataBindingItem<HighlightButtonDataBindingSource> oHighlightButton;
      DataBindingItem<UpdateIconDataBindingSource> oUpdateIcon;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_CAMERA_COURIER_PAYLOAD_MODEL_COMP)
      //  ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(CameraBlackScreenStartTimerMsg)

      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
      static CameraListHandler* getInstance()
      {
         if (NULL == m_poCameraListHandler)
         {
            m_poCameraListHandler = new CameraListHandler();
         }

         return m_poCameraListHandler;
      }
      virtual bool onCourierMessage(const CameraBlackScreenStartTimerMsg& oMsg);
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      uint32 _cameraname_cockpit[30] = {};
      uint32 _cameraname_cabin[30] = {};
      int _CMPPostiion_cockpit[30] = {};
      int _CMPPosition_cabin[30] = {};
      void vprintdata();
      void updateHMIAvailableCamerasFromCAN(uint32 cameraname_arr[], bool camTxtStatusReceived);
      uint32 getActiveCameraName(int selectedindex);
      uint32 getActiveCameraNameCabin(int selectedindex);
      int getSelectedCameraIndex();
      int getSelectedCockpitCameraIndex();
      bool getSpeedLockStatus();
      void setSelectedCameraIndex(int index);
      void setSelectedCockpitCameraIndex(int index);
      bool getCameraStreamStatusCockpit(const int listindex);
      bool getCameraStreamStatusCabin(const int listindex);
      void onUpdCAMACtSignal();
      void onUpdCabinCAMACtSignal();
      void checkCamport();

      bool getCockpitCameraIndex();
      int getCabinListsize();
      int getCockpitListsize();
      void vListUpdate();
      bool _activeCockpitflag = false;
      bool m_SpeedLockActive = false;
      uint32 _activeCameraIndex = -1;
      uint32 _activeCockpitCamera = -1;
      int _cabinIndex = 0;
      int _cockpitIndex = 0;
      uint32 _activeCameraName = 0;
      uint32 _activeCameraNameCabin = 0;
      void updateList(const uint32& listID);
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      CameraDataBindingHandler* m_poCameraDataBindingHandler;

      //Cockpit
      std::map<int, stCameraData> camHexCamData;
      std::vector<std::string> camAvailableSourceNames;
      vector<int> camAvailableXMLTextIdsCockpit;
      void vPrintCamHexCamDataMap();
      void getCameraPositionAndSourceNameValues(int key, int& value, std::string& strCamSrc, bool& streamStatus);
      //Cabin
      std::map<int, stCameraData> camHexCamDataCabin;
      std::vector<std::string> camAvailableSourceNamesCabin;
      void getCameraPositionAndSourceNameValuesCabin(int key, int& value, std::string& strCamSrc, bool& streamStatusCabinflag);
      vector<int> camAvailableXMLTextIdsCabin;

      void setCameraStreamStatusCockpit(const int listindex, const bool status);
      void setCameraStreamStatusCabin(const int listindex, const bool status);

      //List Variables
      vector<int> CANTextId;
      vector<int> vgetCANTextId();

      vector<int> getAllCameraTextIdOnSelection();
      vector<int> getAvailableCameraTextIdOnSelection();

      vector<int> m_availableCameraTxtIds;
      vector<int> getAvailableCameraTextIds();

      //CAN available text ids.
      vector<int> camAvailableCAMTextIdsCockpit;
      vector<int> camAvailableCAMTextIdsCabin;

      int bCheckRequestedCamaraExists(std::string cameraSrcName);
      int bCheckRequestedCabinCameraExists(std::string cameraSrcName);
      void vListUpdateByCamTxtSignal();
      bool bTextIDOverwrittenByCAN;
      void vCockpitListSelection(uint32 listSeletedIndex, activatedScreen screenID);
      bool m_camtxtStatusReceived;
      void vUpdateCameraListData();
      vector<int> getAvailableCameraTextIdsFromCamSignal();
      vector<int> m_availableCameraTxtIdsFromCAN;
      void vUpdateAvailableCameraTextIdsFromCANSignal();
      int getOriginalXMLIndex(std::string camSrcName);

      vector<stCameraData> m_vecCamDataToHmi_CANTxt;
      vector<stCameraData> m_vecCamDataToHmi_CANTxtSignal;
      void vPrepareCAMTextConfiguration(uint32 cameraname_arr[]);
      void fillDataInVector(int indexCMP, int loopSize);
      uint32 m_cameraname_arr[8];

      void prepareConfigBasedOnTwoCMP(uint32 cameraname_arr[], int cmp1IPCamIndex, int cmp2IPCamIndex);
      void prepareConfigBasedOnOneCMP(uint32 cameraname_arr[], int cmp1IPCamIndex);
      int getIPCameraValue(std::string strIpCamName);
      std::string _strSplitCamSrcName[3] = {"cockpitSplitView1", "cockpitSplitView2", "cockpitSplitView3"};

      bool m_bHighlightListItemInCabin;
      void setNoHighlightInList(bool value);

      vector<stCameraData> setConfigForCANTxtId(uint32 cameraname_arr[], int startIndex, int endIndex, int CANTextIDCount);

      vector<int> getAvailableCabinCamTxtIds();
      vector<int> getAvailableCabinCamTxtIdsFromCamSignal();
      vector<int> getAvailableCabinCamTxtIdOnSelection();
      bool bCheckRearCameraAvailable();

      void updateHMIAvailableCamerasFromCAN_TTFIs(uint32 cameraname_arr[], bool camTxtStatusReceived);
      bool bCameraIconHighlights(int selectedIndex, int cmpValue);
      tclAvRoutingParser* _avRoutingParser;
      uint8 getPreviousCanIndex4Cockpit();
      void updatePreviousCanIndex4Cockpit(uint8 prvCanInd4Ckpt);
      void updatePreiousCanIndex4Cabin(uint8 prvCanInd4Cab);
      uint8 getPreviousCanIndex4Cabin();
      uint8 previousCanIndex4Cockpit;
      uint8 previousCanIndex4Cabin;

      int m_prevCabinSelectedIndex;
      int m_prevCabinSourceId;
      void setprevCabinSelectedIndex(int index);
      void vStateMachineExternalTriggerToCameraOrBlackScreen();
      void vContextSwitchRequestSplitOrBlackScreen();
      void vStateMachineTriggerToCameraOrBlackScreen();
      void vContextSwitchRequestCameraOrBlackScreen();
      uint8 m_isBlackScreenEnabledValue;
   private:
      CameraListHandler();
      CameraListHandler(const CameraListHandler&);
      CameraListHandler& operator =(const CameraListHandler&);
};


} // namespace Core
} // namespace App

#endif
