/* ***************************************************************************************
* FILE:          CameraHall.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CameraHall.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CameraHall_h
#define CameraHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "AppHmi_CameraMessages.h"
#include "CameraMain.h"
#include "CameraSourceChangeHandler/CameraSourceChangeHandler.h"
#include "VehicleClientHandler/VehicleClientHandler.h"
#include "NanoMessageClientHandler/NanoMsgClientHandler.h"
#include "CameraConfig/CameraConfig.h"
#include "CameraListHandler.h"
#include "CameraDataBindingHandler.h"
#include "KDSHandler.h"

//applicationSwitch changes
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "Common/PluginClientHandler/PluginClientHandler.h"

#include "Common/DataModel/NavigationModeDBHandler.h"

#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include <Adapter/LanguageHandlerAdapter.h>

#include "CameraAvdeccClientHandler.h"

namespace App {
namespace Core {

class CameraHall
   : public HallComponentBase
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      CameraHall();
      virtual ~CameraHall();
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

   protected:

      virtual bool onCourierMessage(const SwitchApplicationReq& oMsg);
      virtual uint8 readLanguageOnStartUp();
      virtual bool onCourierMessage(const onHardKeyPress& msg);
      bool onCourierMessage(const NavigationCarModeInfo& msg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_CAMERA_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(SwitchApplicationReq)
      ON_COURIER_MESSAGE(onHardKeyPress)
      ON_COURIER_MESSAGE(NavigationCarModeInfo)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_CameraMain)
      COURIER_MSG_DELEGATE_TO_OBJ(_CameraListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_pluginClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_cameraSourceChangeHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_vehicleClientHandler)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      CameraHall(const CameraHall&);
      CameraHall& operator =(const CameraHall&);
      ApplicationSwitchClientComponent* _applicationSwitchClient;//applicationSwitch
      PluginClientHandler* _pluginClientHandler;
      CameraSourceChangeHandler* _cameraSourceChangeHandler;
      VehicleClientHandler* _vehicleClientHandler;
      CameraConfig* _CameraConfig;
      CameraMain* _CameraMain;
      CameraListHandler* _CameraListHandler;
      NanoMsgClientHandler* _NanoMsgClientHandler;
      CameraDataBindingHandler* _CameraDataBindingHandler;
      KDSHandler* _KDSHandler;
      CameraAvdeccClientHandler* _CameraAvdeccClientHandler;

      DataBindingItem<CarModeVisibilityDataBindingSource> _carModeVisibilityStatus;
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
