/**
* @file        :  CameraGui.h
* @addtogroup  :  AppHmi_Camera
* @brief       :  Class which contains all the necessary business logic required to handle gui instance and gadgets
* @copyright   :  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*/
#ifndef CameraGui_h
#define CameraGui_h

#include "AppBase/GuiComponentBase.h"
#include "HMIAppCtrl/Proxy/ProxyHandler.h"
//#include "ProxyHandlerExt/ProxyHandlerExt.h"
#include "ProjectBaseMsgs.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"

namespace App {
namespace Core {

class CameraGui :
   public GuiComponentBase
{
   public:
      CameraGui();
      virtual ~CameraGui();

      virtual void preRun();
      virtual void postRun();

      static void TraceCmd_NotProcessedMsg(const unsigned char* pcu8Data);

   protected:
      virtual unsigned int getDefaultTraceClass();
      virtual void setupCgiInstance();

   private:

      void PersistentValuesRead();
      void PersistentValuesWrite();
      hmibase::services::hmiappctrl::ProxyHandler _hmiAppCtrlProxyHandler;
};


} // namespace Core
} // namespace App


#endif
